/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.wire.Marshallable;

public interface ChronicleBitSet
extends Marshallable,
Closeable {
    public static final long BITS_PER_WORD = 64L;

    public int size();

    public void set(int var1);

    default public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public void set(int var1, int var2);

    default public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    public boolean get(int var1);

    public void clear(int var1);

    public int nextSetBit(int var1, int var2);

    public int nextSetBit(int var1);

    public void clear();

    default public boolean isEmpty() {
        int wordsInUse = this.getWordsInUse();
        for (int i = 0; i < wordsInUse; ++i) {
            if (this.getWord(i) == 0L) continue;
            return false;
        }
        return true;
    }

    default public int length() {
        for (int i = this.getWordsInUse() - 1; i >= 0; --i) {
            long word = this.getWord(i);
            if (word == 0L) continue;
            return Math.toIntExact(64L * (long)(i + 1) - (long)Long.numberOfLeadingZeros(word));
        }
        return 0;
    }

    public int cardinality();

    public int nextClearBit(int var1);

    public void flip(int var1);

    public void flip(int var1, int var2);

    public void clear(int var1, int var2);

    public int getWordsInUse();

    public long getWord(int var1);

    public void setWord(int var1, long var2);

    public void andNot(ChronicleBitSet var1);

    public void and(ChronicleBitSet var1);

    public void xor(ChronicleBitSet var1);

    public void or(ChronicleBitSet var1);

    public boolean intersects(ChronicleBitSet var1);

    public void copyFrom(ChronicleBitSet var1);
}

