/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.domestic.extractor;

import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongUnaryOperator;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.domestic.extractor.DocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToDoubleDocumentExtractor;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ToLongDocumentExtractor {
    public long extractAsLong(@NotNull Wire var1, @NonNegative long var2);

    default public ToLongDocumentExtractor map(@NotNull LongUnaryOperator mapper) {
        ObjectUtils.requireNonNull((Object)mapper);
        return (wire, index) -> {
            long value = this.extractAsLong(wire, index);
            if (value == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return mapper.applyAsLong(value);
        };
    }

    default public <T> DocumentExtractor<T> mapToObj(@NotNull LongFunction<? extends T> mapper) {
        ObjectUtils.requireNonNull(mapper);
        return (wire, index) -> {
            long value = this.extractAsLong(wire, index);
            if (value == Long.MIN_VALUE) {
                return null;
            }
            return mapper.apply(value);
        };
    }

    default public ToDoubleDocumentExtractor mapToDouble(@NotNull LongToDoubleFunction mapper) {
        ObjectUtils.requireNonNull((Object)mapper);
        return (wire, index) -> {
            long value = this.extractAsLong(wire, index);
            if (value == Long.MIN_VALUE) {
                return Double.NaN;
            }
            return mapper.applyAsDouble(value);
        };
    }

    default public ToLongDocumentExtractor filter(@NotNull LongPredicate predicate) {
        ObjectUtils.requireNonNull((Object)predicate);
        return (wire, index) -> {
            long value = this.extractAsLong(wire, index);
            if (value == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return predicate.test(value) ? value : Long.MIN_VALUE;
        };
    }

    public static ToLongDocumentExtractor extractingIndex() {
        return (wire, index) -> index;
    }
}

