/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.config.Redacted;
import org.apache.cassandra.config.Replaces;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.security.DisableSslContextFactory;
import org.apache.cassandra.security.ISslContextFactory;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionOptions {
    Logger logger = LoggerFactory.getLogger(EncryptionOptions.class);
    public final ParameterizedClass ssl_context_factory;
    @Redacted
    public final String keystore;
    @Nullable
    @Redacted
    public final String keystore_password;
    @Redacted
    public final String truststore;
    @Nullable
    @Redacted
    public final String truststore_password;
    public final List<String> cipher_suites;
    protected String protocol;
    protected List<String> accepted_protocols;
    public final String algorithm;
    public final String store_type;
    public final boolean require_client_auth;
    public final boolean require_endpoint_verification;
    protected Boolean enabled;
    protected Boolean optional;
    protected Boolean isEnabled;
    protected Boolean isOptional;
    public transient ISslContextFactory sslContextFactoryInstance;

    public EncryptionOptions() {
        this.ssl_context_factory = new ParameterizedClass("org.apache.cassandra.security.DefaultSslContextFactory", new HashMap<String, String>());
        this.keystore = "conf/.keystore";
        this.keystore_password = null;
        this.truststore = "conf/.truststore";
        this.truststore_password = null;
        this.cipher_suites = null;
        this.protocol = null;
        this.accepted_protocols = null;
        this.algorithm = null;
        this.store_type = "JKS";
        this.require_client_auth = false;
        this.require_endpoint_verification = false;
        this.enabled = null;
        this.optional = null;
    }

    public EncryptionOptions(ParameterizedClass ssl_context_factory, String keystore, String keystore_password, String truststore, String truststore_password, List<String> cipher_suites, String protocol, List<String> accepted_protocols, String algorithm, String store_type, boolean require_client_auth, boolean require_endpoint_verification, Boolean enabled, Boolean optional) {
        this.ssl_context_factory = ssl_context_factory;
        this.keystore = keystore;
        this.keystore_password = keystore_password;
        this.truststore = truststore;
        this.truststore_password = truststore_password;
        this.cipher_suites = cipher_suites;
        this.protocol = protocol;
        this.accepted_protocols = accepted_protocols;
        this.algorithm = algorithm;
        this.store_type = store_type;
        this.require_client_auth = require_client_auth;
        this.require_endpoint_verification = require_endpoint_verification;
        this.enabled = enabled;
        this.optional = optional;
    }

    public EncryptionOptions(EncryptionOptions options) {
        this.ssl_context_factory = options.ssl_context_factory;
        this.keystore = options.keystore;
        this.keystore_password = options.keystore_password;
        this.truststore = options.truststore;
        this.truststore_password = options.truststore_password;
        this.cipher_suites = options.cipher_suites;
        this.protocol = options.protocol;
        this.accepted_protocols = options.accepted_protocols;
        this.algorithm = options.algorithm;
        this.store_type = options.store_type;
        this.require_client_auth = options.require_client_auth;
        this.require_endpoint_verification = options.require_endpoint_verification;
        this.enabled = options.enabled;
        this.optional = options.optional;
    }

    public EncryptionOptions applyConfig() {
        this.ensureConfigNotApplied();
        this.initializeSslContextFactory();
        this.isEnabled = this.enabled != null && this.enabled != false;
        this.isOptional = this.optional != null ? this.optional : (this.sslContextFactoryInstance.hasKeystore() ? Boolean.valueOf(this.isEnabled == false) : Boolean.valueOf(false));
        return this;
    }

    private void prepareSslContextFactoryParameterizedKeys(Map<String, Object> sslContextFactoryParameters) {
        if (this.ssl_context_factory.parameters != null) {
            Set<String> configKeys = ConfigKey.asSet();
            for (Map.Entry<String, String> entry : this.ssl_context_factory.parameters.entrySet()) {
                if (configKeys.contains(entry.getKey().toLowerCase())) {
                    throw new IllegalArgumentException("SslContextFactory " + this.ssl_context_factory.class_name + " should configure '" + entry.getKey() + "' as encryption_options instead of parameterized keys");
                }
                sslContextFactoryParameters.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void fillSslContextParams(Map<String, Object> sslContextFactoryParameters) {
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.KEYSTORE, this.keystore);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.KEYSTORE_PASSWORD, this.keystore_password);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.TRUSTSTORE, this.truststore);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.TRUSTSTORE_PASSWORD, this.truststore_password);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.CIPHER_SUITES, this.cipher_suites);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.PROTOCOL, this.protocol);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.ACCEPTED_PROTOCOLS, this.accepted_protocols);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.ALGORITHM, this.algorithm);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.STORE_TYPE, this.store_type);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.REQUIRE_CLIENT_AUTH, this.require_client_auth);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.REQUIRE_ENDPOINT_VERIFICATION, this.require_endpoint_verification);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.ENABLED, this.enabled);
        EncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.OPTIONAL, this.optional);
    }

    private void initializeSslContextFactory() {
        HashMap<String, Object> sslContextFactoryParameters = new HashMap<String, Object>();
        this.prepareSslContextFactoryParameterizedKeys(sslContextFactoryParameters);
        this.fillSslContextParams(sslContextFactoryParameters);
        this.sslContextFactoryInstance = CassandraRelevantProperties.TEST_JVM_DTEST_DISABLE_SSL.getBoolean() ? new DisableSslContextFactory() : FBUtilities.newSslContextFactory(this.ssl_context_factory.class_name, sslContextFactoryParameters);
    }

    protected static void putSslContextFactoryParameter(Map<String, Object> existingParameters, ConfigKey configKey, Object value) {
        if (value != null) {
            existingParameters.put(configKey.getKeyName(), value);
        }
    }

    private void ensureConfigApplied() {
        if (this.isEnabled == null || this.isOptional == null) {
            throw new IllegalStateException("EncryptionOptions.applyConfig must be called first");
        }
    }

    private void ensureConfigNotApplied() {
        if (this.isEnabled != null || this.isOptional != null) {
            throw new IllegalStateException("EncryptionOptions cannot be changed after configuration applied");
        }
    }

    public Boolean getEnabled() {
        this.ensureConfigApplied();
        return this.isEnabled;
    }

    public void setEnabled(Boolean enabled) {
        this.ensureConfigNotApplied();
        this.enabled = enabled;
    }

    public Boolean getOptional() {
        this.ensureConfigApplied();
        return this.isOptional;
    }

    public void setOptional(Boolean optional) {
        this.ensureConfigNotApplied();
        this.optional = optional;
    }

    @VisibleForTesting
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setAcceptedProtocols(List<String> accepted_protocols) {
        this.accepted_protocols = accepted_protocols == null ? null : ImmutableList.copyOf(accepted_protocols);
    }

    public List<String> getAcceptedProtocols() {
        return this.sslContextFactoryInstance == null ? null : this.sslContextFactoryInstance.getAcceptedProtocols();
    }

    public String[] acceptedProtocolsArray() {
        List<String> ap = this.getAcceptedProtocols();
        return ap == null ? new String[]{} : ap.toArray(new String[0]);
    }

    public String[] cipherSuitesArray() {
        return this.cipher_suites == null ? null : this.cipher_suites.toArray(new String[0]);
    }

    public TlsEncryptionPolicy tlsEncryptionPolicy() {
        if (this.getOptional().booleanValue()) {
            return TlsEncryptionPolicy.OPTIONAL;
        }
        if (this.getEnabled().booleanValue()) {
            return TlsEncryptionPolicy.ENCRYPTED;
        }
        return TlsEncryptionPolicy.UNENCRYPTED;
    }

    public EncryptionOptions withSslContextFactory(ParameterizedClass sslContextFactoryClass) {
        return new EncryptionOptions(sslContextFactoryClass, this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withKeyStore(String keystore) {
        return new EncryptionOptions(this.ssl_context_factory, keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withKeyStorePassword(String keystore_password) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withTrustStore(String truststore) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withTrustStorePassword(String truststore_password) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withCipherSuites(List<String> cipher_suites) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withCipherSuites(String ... cipher_suites) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, (List<String>)ImmutableList.copyOf((Object[])cipher_suites), this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withProtocol(String protocol) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withAcceptedProtocols(List<String> accepted_protocols) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, (List<String>)(accepted_protocols == null ? null : ImmutableList.copyOf(accepted_protocols)), this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withAlgorithm(String algorithm) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withStoreType(String store_type) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withRequireClientAuth(boolean require_client_auth) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withRequireEndpointVerification(boolean require_endpoint_verification) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withEnabled(boolean enabled) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withOptional(Boolean optional) {
        return new EncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, optional).applyConfig();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionOptions opt = (EncryptionOptions)o;
        return this.enabled == opt.enabled && this.optional == opt.optional && this.require_client_auth == opt.require_client_auth && this.require_endpoint_verification == opt.require_endpoint_verification && Objects.equals(this.keystore, opt.keystore) && Objects.equals(this.keystore_password, opt.keystore_password) && Objects.equals(this.truststore, opt.truststore) && Objects.equals(this.truststore_password, opt.truststore_password) && Objects.equals(this.protocol, opt.protocol) && Objects.equals(this.accepted_protocols, opt.accepted_protocols) && Objects.equals(this.algorithm, opt.algorithm) && Objects.equals(this.store_type, opt.store_type) && Objects.equals(this.cipher_suites, opt.cipher_suites) && Objects.equals(this.ssl_context_factory, opt.ssl_context_factory);
    }

    public int hashCode() {
        int result = 0;
        result += 31 * (this.keystore == null ? 0 : this.keystore.hashCode());
        result += 31 * (this.keystore_password == null ? 0 : this.keystore_password.hashCode());
        result += 31 * (this.truststore == null ? 0 : this.truststore.hashCode());
        result += 31 * (this.truststore_password == null ? 0 : this.truststore_password.hashCode());
        result += 31 * (this.protocol == null ? 0 : this.protocol.hashCode());
        result += 31 * (this.accepted_protocols == null ? 0 : this.accepted_protocols.hashCode());
        result += 31 * (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result += 31 * (this.store_type == null ? 0 : this.store_type.hashCode());
        result += 31 * (this.enabled == null ? 0 : Boolean.hashCode(this.enabled));
        result += 31 * (this.optional == null ? 0 : Boolean.hashCode(this.optional));
        result += 31 * (this.cipher_suites == null ? 0 : this.cipher_suites.hashCode());
        result += 31 * Boolean.hashCode(this.require_client_auth);
        result += 31 * Boolean.hashCode(this.require_endpoint_verification);
        return result += 31 * (this.ssl_context_factory == null ? 0 : this.ssl_context_factory.hashCode());
    }

    public static class ServerEncryptionOptions
    extends EncryptionOptions {
        public final InternodeEncryption internode_encryption;
        @Replaces(oldName="enable_legacy_ssl_storage_port", deprecated=true)
        public final boolean legacy_ssl_storage_port_enabled;
        public final String outbound_keystore;
        @Nullable
        public final String outbound_keystore_password;

        public ServerEncryptionOptions() {
            this.internode_encryption = InternodeEncryption.none;
            this.legacy_ssl_storage_port_enabled = false;
            this.outbound_keystore = null;
            this.outbound_keystore_password = null;
        }

        public ServerEncryptionOptions(ParameterizedClass sslContextFactoryClass, String keystore, String keystore_password, String outbound_keystore, String outbound_keystore_password, String truststore, String truststore_password, List<String> cipher_suites, String protocol, List<String> accepted_protocols, String algorithm, String store_type, boolean require_client_auth, boolean require_endpoint_verification, Boolean optional, InternodeEncryption internode_encryption, boolean legacy_ssl_storage_port_enabled) {
            super(sslContextFactoryClass, keystore, keystore_password, truststore, truststore_password, cipher_suites, protocol, accepted_protocols, algorithm, store_type, require_client_auth, require_endpoint_verification, null, optional);
            this.internode_encryption = internode_encryption;
            this.legacy_ssl_storage_port_enabled = legacy_ssl_storage_port_enabled;
            this.outbound_keystore = outbound_keystore;
            this.outbound_keystore_password = outbound_keystore_password;
        }

        public ServerEncryptionOptions(ServerEncryptionOptions options) {
            super(options);
            this.internode_encryption = options.internode_encryption;
            this.legacy_ssl_storage_port_enabled = options.legacy_ssl_storage_port_enabled;
            this.outbound_keystore = options.outbound_keystore;
            this.outbound_keystore_password = options.outbound_keystore_password;
        }

        @Override
        protected void fillSslContextParams(Map<String, Object> sslContextFactoryParameters) {
            super.fillSslContextParams(sslContextFactoryParameters);
            ServerEncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.OUTBOUND_KEYSTORE, this.outbound_keystore);
            ServerEncryptionOptions.putSslContextFactoryParameter(sslContextFactoryParameters, ConfigKey.OUTBOUND_KEYSTORE_PASSWORD, this.outbound_keystore_password);
        }

        @Override
        public EncryptionOptions applyConfig() {
            return this.applyConfigInternal();
        }

        private ServerEncryptionOptions applyConfigInternal() {
            super.applyConfig();
            this.isEnabled = this.internode_encryption != InternodeEncryption.none;
            if (this.enabled != null && this.enabled.booleanValue() && !this.isEnabled.booleanValue()) {
                this.logger.warn("Setting server_encryption_options.enabled has no effect, use internode_encryption");
            }
            if (this.require_client_auth && (this.internode_encryption == InternodeEncryption.rack || this.internode_encryption == InternodeEncryption.dc)) {
                this.logger.warn("Setting require_client_auth is incompatible with 'rack' and 'dc' internode_encryption values. It is possible for an internode connection to pretend to be in the same rack/dc by spoofing its broadcast address in the handshake and bypass authentication. To ensure that mutual TLS authentication is not bypassed, please set internode_encryption to 'all'. Continuing with insecure configuration.");
            }
            this.isOptional = this.isOptional != false || this.internode_encryption == InternodeEncryption.rack || this.internode_encryption == InternodeEncryption.dc;
            return this;
        }

        public boolean shouldEncrypt(InetAddressAndPort endpoint) {
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            switch (this.internode_encryption) {
                case none: {
                    return false;
                }
                case all: {
                    break;
                }
                case dc: {
                    if (!snitch.getDatacenter(endpoint).equals(snitch.getLocalDatacenter())) break;
                    return false;
                }
                case rack: {
                    if (!snitch.getRack(endpoint).equals(snitch.getLocalRack()) || !snitch.getDatacenter(endpoint).equals(snitch.getLocalDatacenter())) break;
                    return false;
                }
            }
            return true;
        }

        public boolean isExplicitlyOptional() {
            return this.optional != null && this.optional != false;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ServerEncryptionOptions opt = (ServerEncryptionOptions)o;
            return this.internode_encryption == opt.internode_encryption && this.legacy_ssl_storage_port_enabled == opt.legacy_ssl_storage_port_enabled && Objects.equals(this.outbound_keystore, opt.outbound_keystore) && Objects.equals(this.outbound_keystore_password, opt.outbound_keystore_password);
        }

        @Override
        public int hashCode() {
            int result = 0;
            result += 31 * super.hashCode();
            result += 31 * (this.internode_encryption == null ? 0 : this.internode_encryption.hashCode());
            result += 31 * Boolean.hashCode(this.legacy_ssl_storage_port_enabled);
            result += 31 * (this.outbound_keystore == null ? 0 : this.outbound_keystore.hashCode());
            return result += 31 * (this.outbound_keystore_password == null ? 0 : this.outbound_keystore_password.hashCode());
        }

        @Override
        public ServerEncryptionOptions withSslContextFactory(ParameterizedClass sslContextFactoryClass) {
            return new ServerEncryptionOptions(sslContextFactoryClass, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withKeyStore(String keystore) {
            return new ServerEncryptionOptions(this.ssl_context_factory, keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withKeyStorePassword(String keystore_password) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withTrustStore(String truststore) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withTrustStorePassword(String truststore_password) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withCipherSuites(List<String> cipher_suites) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withCipherSuites(String ... cipher_suites) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, Arrays.asList(cipher_suites), this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withProtocol(String protocol) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withAcceptedProtocols(List<String> accepted_protocols) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withAlgorithm(String algorithm) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withStoreType(String store_type) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withRequireClientAuth(boolean require_client_auth) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withRequireEndpointVerification(boolean require_endpoint_verification) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        public ServerEncryptionOptions withOptional(boolean optional) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        public ServerEncryptionOptions withInternodeEncryption(InternodeEncryption internode_encryption) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        public ServerEncryptionOptions withLegacySslStoragePort(boolean enable_legacy_ssl_storage_port) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        public ServerEncryptionOptions withOutboundKeystore(String outboundKeystore) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, outboundKeystore, this.outbound_keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        public ServerEncryptionOptions withOutboundKeystorePassword(String outboundKeystorePassword) {
            return new ServerEncryptionOptions(this.ssl_context_factory, this.keystore, this.keystore_password, this.outbound_keystore, outboundKeystorePassword, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.legacy_ssl_storage_port_enabled).applyConfigInternal();
        }

        public static enum InternodeEncryption {
            all,
            none,
            dc,
            rack;

        }
    }

    public static enum ConfigKey {
        KEYSTORE("keystore"),
        KEYSTORE_PASSWORD("keystore_password"),
        OUTBOUND_KEYSTORE("outbound_keystore"),
        OUTBOUND_KEYSTORE_PASSWORD("outbound_keystore_password"),
        TRUSTSTORE("truststore"),
        TRUSTSTORE_PASSWORD("truststore_password"),
        CIPHER_SUITES("cipher_suites"),
        PROTOCOL("protocol"),
        ACCEPTED_PROTOCOLS("accepted_protocols"),
        ALGORITHM("algorithm"),
        STORE_TYPE("store_type"),
        REQUIRE_CLIENT_AUTH("require_client_auth"),
        REQUIRE_ENDPOINT_VERIFICATION("require_endpoint_verification"),
        ENABLED("enabled"),
        OPTIONAL("optional");

        final String keyName;

        private ConfigKey(String keyName) {
            this.keyName = keyName;
        }

        String getKeyName() {
            return this.keyName;
        }

        static Set<String> asSet() {
            ConfigKey[] values;
            HashSet<String> valueSet = new HashSet<String>();
            for (ConfigKey key : values = ConfigKey.values()) {
                valueSet.add(key.getKeyName().toLowerCase());
            }
            return valueSet;
        }
    }

    public static enum TlsEncryptionPolicy {
        UNENCRYPTED("unencrypted"),
        OPTIONAL("optionally encrypted"),
        ENCRYPTED("encrypted");

        private final String description;

        private TlsEncryptionPolicy(String description) {
            this.description = description;
        }

        public String description() {
            return this.description;
        }
    }
}

