/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.AbstractCommitLogSegmentManager;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.db.commitlog.FileDirectSegment;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.SimpleCachedBufferPool;

public class CompressedSegment
extends FileDirectSegment {
    static final int COMPRESSED_MARKER_SIZE = 12;
    final ICompressor compressor;

    CompressedSegment(AbstractCommitLogSegmentManager manager, ThrowingFunction<Path, FileChannel, IOException> channelFactory) {
        super(manager, channelFactory);
        this.compressor = manager.getConfiguration().getCompressor();
    }

    @Override
    void write(int startMarker, int nextMarker) {
        int contentStart = startMarker + 8;
        int length = nextMarker - contentStart;
        assert (length > 0 || length == 0 && !this.isStillAllocating());
        try {
            int neededBufferSize = this.compressor.initialCompressedBufferLength(length) + 12;
            ByteBuffer compressedBuffer = this.manager.getBufferPool().getThreadLocalReusableBuffer(neededBufferSize);
            ByteBuffer inputBuffer = this.buffer.duplicate();
            inputBuffer.limit(contentStart + length).position(contentStart);
            compressedBuffer.limit(compressedBuffer.capacity()).position(12);
            this.compressor.compress(inputBuffer, compressedBuffer);
            compressedBuffer.flip();
            compressedBuffer.putInt(8, length);
            CompressedSegment.writeSyncMarker(this.id, compressedBuffer, 0, (int)this.channel.position(), (int)this.channel.position() + compressedBuffer.remaining());
            this.manager.addSize(compressedBuffer.limit());
            this.channel.write(compressedBuffer);
            assert (this.channel.position() - this.lastWrittenPos == (long)compressedBuffer.limit());
            this.lastWrittenPos = this.channel.position();
        }
        catch (Exception e) {
            throw new FSWriteError((Throwable)e, this.getPath());
        }
    }

    @Override
    public long onDiskSize() {
        return this.lastWrittenPos;
    }

    protected static class CompressedSegmentBuilder
    extends CommitLogSegment.Builder {
        public CompressedSegmentBuilder(AbstractCommitLogSegmentManager segmentManager) {
            super(segmentManager);
        }

        @Override
        public CompressedSegment build() {
            return new CompressedSegment(this.segmentManager, (ThrowingFunction<Path, FileChannel, IOException>)((ThrowingFunction)path -> FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE)));
        }

        @Override
        public SimpleCachedBufferPool createBufferPool() {
            return new SimpleCachedBufferPool(DatabaseDescriptor.getCommitLogMaxCompressionBuffersInPool(), DatabaseDescriptor.getCommitLogSegmentSize(), this.segmentManager.getConfiguration().getCompressor().preferredBufferType());
        }
    }
}

