/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.virtual;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Loader;
import org.apache.cassandra.config.Properties;
import org.apache.cassandra.config.Redacted;
import org.apache.cassandra.config.Replacement;
import org.apache.cassandra.config.Replacements;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.virtual.AbstractVirtualTable;
import org.apache.cassandra.db.virtual.SimpleDataSet;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.utils.JsonUtils;
import org.yaml.snakeyaml.introspector.Property;

final class SettingsTable
extends AbstractVirtualTable {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final Map<String, String> BACKWARDS_COMPATABLE_NAMES = ImmutableMap.copyOf(SettingsTable.getBackwardsCompatableNames());
    protected static final Map<String, Property> PROPERTIES = ImmutableMap.copyOf(SettingsTable.getProperties());
    private final Config config;
    private final boolean useJsonFormat;

    SettingsTable(String keyspace) {
        this(keyspace, DatabaseDescriptor.getRawConfig());
    }

    SettingsTable(String keyspace, Config config) {
        super(TableMetadata.builder(keyspace, "settings").comment("current settings").kind(TableMetadata.Kind.VIRTUAL).partitioner(new LocalPartitioner(UTF8Type.instance)).addPartitionKeyColumn(NAME, UTF8Type.instance).addRegularColumn(VALUE, UTF8Type.instance).build());
        this.config = config;
        this.useJsonFormat = CassandraRelevantProperties.VIRTUAL_TABLE_COMPLEX_SETTINGS_FORMAT_JSON.getBoolean();
    }

    @Override
    public AbstractVirtualTable.DataSet data(DecoratedKey partitionKey) {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        String name = (String)UTF8Type.instance.compose(partitionKey.getKey());
        if (BACKWARDS_COMPATABLE_NAMES.containsKey(name)) {
            ClientWarn.instance.warn("key '" + name + "' is deprecated; should switch to '" + BACKWARDS_COMPATABLE_NAMES.get(name) + "'");
        }
        if (PROPERTIES.containsKey(name)) {
            result.row(name).column(VALUE, this.getValue(PROPERTIES.get(name)));
        }
        return result;
    }

    @Override
    public AbstractVirtualTable.DataSet data() {
        SimpleDataSet result = new SimpleDataSet(this.metadata());
        for (Map.Entry<String, Property> e : PROPERTIES.entrySet()) {
            result.row(e.getKey()).column(VALUE, this.getValue(e.getValue()));
        }
        return result;
    }

    @VisibleForTesting
    String getValue(Property prop) {
        Redacted maybeCredential = (Redacted)prop.getAnnotation(Redacted.class);
        if (maybeCredential != null) {
            return maybeCredential.redactedValue();
        }
        Object value = prop.get((Object)this.config);
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return this.tryConstructJson(Arrays.asList((Object[])value));
        }
        if (value instanceof Collection) {
            return this.tryConstructJson(value);
        }
        if (value instanceof Map) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (((String)entry.getKey()).endsWith("_password") || ((String)entry.getKey()).equals("password")) {
                    map.put((String)entry.getKey(), "<REDACTED>");
                    continue;
                }
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
            return this.tryConstructJson(map);
        }
        return value.toString();
    }

    private String tryConstructJson(Object o) {
        if (this.useJsonFormat) {
            try {
                return JsonUtils.JSON_OBJECT_MAPPER.writeValueAsString(o);
            }
            catch (Exception e) {
                return o.toString();
            }
        }
        return o.toString();
    }

    private static Map<String, Property> getProperties() {
        Loader loader = Properties.defaultLoader();
        Map<String, Property> properties = loader.flatten(Config.class);
        Map<String, Replacement> replacements = Replacements.getNameReplacements(Config.class).get(Config.class);
        if (replacements != null) {
            for (Replacement replacement : replacements.values()) {
                Property latest = properties.get(replacement.newName);
                assert (latest != null) : "Unable to find replacement new name: " + replacement.newName;
                Property conflict = properties.put(replacement.oldName, replacement.toProperty(latest));
                assert (conflict == null || replacement.oldName.equals(replacement.newName)) : String.format("New property %s attempted to replace %s, but this property already exists", latest.getName(), conflict.getName());
            }
        }
        for (Map.Entry entry : BACKWARDS_COMPATABLE_NAMES.entrySet()) {
            String oldName = (String)entry.getKey();
            if (properties.containsKey(oldName)) {
                throw new AssertionError((Object)("Name " + oldName + " is present in Config, this adds a conflict as this name had a different meaning in " + SettingsTable.class.getSimpleName()));
            }
            String newName = (String)entry.getValue();
            Property prop = Objects.requireNonNull(properties.get(newName), newName + " cant be found for " + oldName);
            properties.put(oldName, Properties.rename(oldName, prop));
        }
        return properties;
    }

    private static Map<String, String> getBackwardsCompatableNames() {
        HashMap<String, String> names = new HashMap<String, String>();
        names.put("audit_logging_options_logger", "audit_logging_options.logger.class_name");
        names.put("server_encryption_options_client_auth", "server_encryption_options.require_client_auth");
        names.put("server_encryption_options_endpoint_verification", "server_encryption_options.require_endpoint_verification");
        names.put("server_encryption_options_legacy_ssl_storage_port", "server_encryption_options.legacy_ssl_storage_port_enabled");
        names.put("server_encryption_options_protocol", "server_encryption_options.accepted_protocols");
        names.put("audit_logging_options_audit_logs_dir", "audit_logging_options.audit_logs_dir");
        names.put("audit_logging_options_enabled", "audit_logging_options.enabled");
        names.put("audit_logging_options_excluded_categories", "audit_logging_options.excluded_categories");
        names.put("audit_logging_options_excluded_keyspaces", "audit_logging_options.excluded_keyspaces");
        names.put("audit_logging_options_excluded_users", "audit_logging_options.excluded_users");
        names.put("audit_logging_options_included_categories", "audit_logging_options.included_categories");
        names.put("audit_logging_options_included_keyspaces", "audit_logging_options.included_keyspaces");
        names.put("audit_logging_options_included_users", "audit_logging_options.included_users");
        names.put("server_encryption_options_algorithm", "server_encryption_options.algorithm");
        names.put("server_encryption_options_cipher_suites", "server_encryption_options.cipher_suites");
        names.put("server_encryption_options_enabled", "server_encryption_options.enabled");
        names.put("server_encryption_options_internode_encryption", "server_encryption_options.internode_encryption");
        names.put("server_encryption_options_optional", "server_encryption_options.optional");
        names.put("transparent_data_encryption_options_chunk_length_kb", "transparent_data_encryption_options.chunk_length_kb");
        names.put("transparent_data_encryption_options_cipher", "transparent_data_encryption_options.cipher");
        names.put("transparent_data_encryption_options_enabled", "transparent_data_encryption_options.enabled");
        names.put("transparent_data_encryption_options_iv_length", "transparent_data_encryption_options.iv_length");
        return names;
    }
}

