/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;
import org.apache.commons.lang3.ArrayUtils;

public class ByteOrderedPartitioner
implements IPartitioner {
    public static final BytesToken MINIMUM = new BytesToken(ArrayUtils.EMPTY_BYTE_ARRAY);
    public static final BigInteger BYTE_MASK = new BigInteger("255");
    private static final long EMPTY_SIZE = ObjectSizes.measure(MINIMUM);
    public static final ByteOrderedPartitioner instance = new ByteOrderedPartitioner();
    private final Token.TokenFactory tokenFactory = new Token.TokenFactory(){

        @Override
        public Token fromComparableBytes(ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
            return new BytesToken(ByteSourceInverse.getUnescapedBytes(comparableBytes));
        }

        @Override
        public ByteBuffer toByteArray(Token token) {
            BytesToken bytesToken = (BytesToken)token;
            return ByteBuffer.wrap(bytesToken.token);
        }

        @Override
        public Token fromByteArray(ByteBuffer bytes) {
            return new BytesToken(bytes);
        }

        @Override
        public int byteSize(Token token) {
            return ((BytesToken)token).token.length;
        }

        @Override
        public String toString(Token token) {
            BytesToken bytesToken = (BytesToken)token;
            return Hex.bytesToHex(bytesToken.token);
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            try {
                if (((String)token).length() % 2 == 1) {
                    token = "0" + (String)token;
                }
                Hex.hexToBytes((String)token);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Token " + (String)token + " contains non-hex digits");
            }
        }

        @Override
        public Token fromString(String string) {
            if (((String)string).length() % 2 == 1) {
                string = "0" + (String)string;
            }
            return new BytesToken(Hex.hexToBytes((String)string));
        }
    };

    @Override
    public BytesToken getToken(ByteBuffer key) {
        if (key.remaining() == 0) {
            return MINIMUM;
        }
        return new BytesToken(key);
    }

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        return new BufferDecoratedKey(this.getToken(key), key);
    }

    @Override
    public BytesToken midpoint(Token lt, Token rt) {
        BytesToken ltoken = (BytesToken)lt;
        BytesToken rtoken = (BytesToken)rt;
        int sigbytes = Math.max(ltoken.token.length, rtoken.token.length);
        BigInteger left = this.bigForBytes(ltoken.token, sigbytes);
        BigInteger right = this.bigForBytes(rtoken.token, sigbytes);
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 8 * sigbytes);
        return new BytesToken(this.bytesForBig((BigInteger)midpair.left, sigbytes, (Boolean)midpair.right));
    }

    @Override
    public Token split(Token left, Token right, double ratioToLeft) {
        throw new UnsupportedOperationException();
    }

    private BigInteger bigForBytes(byte[] bytes, int sigbytes) {
        byte[] b;
        if (sigbytes != bytes.length) {
            b = new byte[sigbytes];
            System.arraycopy(bytes, 0, b, 0, bytes.length);
        } else {
            b = bytes;
        }
        return new BigInteger(1, b);
    }

    private byte[] bytesForBig(BigInteger big, int sigbytes, boolean remainder) {
        byte[] bytes = new byte[sigbytes + (remainder ? 1 : 0)];
        if (remainder) {
            int n = sigbytes;
            bytes[n] = (byte)(bytes[n] | 0x80);
        }
        for (int i = 0; i < sigbytes; ++i) {
            int maskpos = 8 * (sigbytes - (i + 1));
            bytes[i] = (byte)(big.and(BYTE_MASK.shiftLeft(maskpos)).shiftRight(maskpos).intValue() & 0xFF);
        }
        return bytes;
    }

    @Override
    public BytesToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BytesToken getRandomToken() {
        return this.getRandomToken(ThreadLocalRandom.current());
    }

    @Override
    public BytesToken getRandomToken(Random random) {
        byte[] buffer = new byte[16];
        random.nextBytes(buffer);
        return new BytesToken(buffer);
    }

    @Override
    public Token.TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap allTokens = Maps.newHashMapWithExpectedSize((int)sortedTokens.size());
        ArrayList<Range<Token>> sortedRanges = new ArrayList<Range<Token>>(sortedTokens.size());
        Token lastToken = sortedTokens.get(sortedTokens.size() - 1);
        for (Token node : sortedTokens) {
            allTokens.put(node, Float.valueOf(0.0f));
            sortedRanges.add(new Range<Token>(lastToken, node));
            lastToken = node;
        }
        for (String ks : Schema.instance.getKeyspaces()) {
            for (TableMetadata cfmd : Schema.instance.getTablesAndViews(ks)) {
                for (Range r : sortedRanges) {
                    allTokens.put((Token)r.right, Float.valueOf(((Float)allTokens.get(r.right)).floatValue() + (float)StorageService.instance.getSplits(ks, cfmd.name, r, 1).size()));
                }
            }
        }
        Float total = Float.valueOf(0.0f);
        for (Float f : allTokens.values()) {
            total = Float.valueOf(total.floatValue() + f.floatValue());
        }
        for (Map.Entry row : allTokens.entrySet()) {
            allTokens.put((Token)row.getKey(), Float.valueOf(((Float)row.getValue()).floatValue() / total.floatValue()));
        }
        return allTokens;
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return BytesType.instance;
    }

    @Override
    public AbstractType<?> partitionOrdering() {
        return BytesType.instance;
    }

    public static class BytesToken
    extends Token {
        static final long serialVersionUID = -2630749093733680626L;
        final byte[] token;

        public BytesToken(ByteBuffer token) {
            this(ByteBufferUtil.getArray(token));
        }

        public BytesToken(byte[] token) {
            this.token = token;
        }

        public String toString() {
            return Hex.bytesToHex(this.token);
        }

        @Override
        public int compareTo(Token other) {
            BytesToken o = (BytesToken)other;
            return FBUtilities.compareUnsigned(this.token, o.token, 0, 0, this.token.length, o.token.length);
        }

        public int hashCode() {
            int prime = 31;
            return 31 + Arrays.hashCode(this.token);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BytesToken)) {
                return false;
            }
            BytesToken other = (BytesToken)obj;
            return Arrays.equals(this.token, other.token);
        }

        @Override
        public ByteSource asComparableBytes(ByteComparable.Version version) {
            return ByteSource.of(this.token, version);
        }

        @Override
        public IPartitioner getPartitioner() {
            return instance;
        }

        @Override
        public long getHeapSize() {
            return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.token);
        }

        @Override
        public Object getTokenValue() {
            return this.token;
        }

        @Override
        public double size(Token next) {
            throw new UnsupportedOperationException(String.format("Token type %s does not support token allocation.", this.getClass().getSimpleName()));
        }

        @Override
        public Token nextValidToken() {
            throw new UnsupportedOperationException(String.format("Token type %s does not support token allocation.", this.getClass().getSimpleName()));
        }
    }
}

