/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocator;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorFactory;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAllocation {
    public static final double WARN_STDEV_GROWTH = 0.05;
    private static final Logger logger = LoggerFactory.getLogger(TokenAllocation.class);
    final TokenMetadata tokenMetadata;
    final AbstractReplicationStrategy replicationStrategy;
    final int numTokens;
    final Map<String, Map<String, StrategyAdapter>> strategyByRackDc = new HashMap<String, Map<String, StrategyAdapter>>();

    private TokenAllocation(TokenMetadata tokenMetadata, AbstractReplicationStrategy replicationStrategy, int numTokens) {
        this.tokenMetadata = tokenMetadata.cloneOnlyTokenMap();
        this.replicationStrategy = replicationStrategy;
        this.numTokens = numTokens;
    }

    public static Collection<Token> allocateTokens(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, InetAddressAndPort endpoint, int numTokens) {
        return TokenAllocation.create(tokenMetadata, rs, numTokens).allocate(endpoint);
    }

    public static Collection<Token> allocateTokens(TokenMetadata tokenMetadata, int replicas, InetAddressAndPort endpoint, int numTokens) {
        return TokenAllocation.create(DatabaseDescriptor.getEndpointSnitch(), tokenMetadata, replicas, numTokens).allocate(endpoint);
    }

    static TokenAllocation create(IEndpointSnitch snitch, TokenMetadata tokenMetadata, int replicas, int numTokens) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(snitch.getLocalDatacenter(), Integer.toString(replicas));
        NetworkTopologyStrategy fakeReplicationStrategy = new NetworkTopologyStrategy(null, tokenMetadata, snitch, options);
        TokenAllocation allocator = new TokenAllocation(tokenMetadata, fakeReplicationStrategy, numTokens);
        return allocator;
    }

    static TokenAllocation create(TokenMetadata tokenMetadata, AbstractReplicationStrategy rs, int numTokens) {
        return new TokenAllocation(tokenMetadata, rs, numTokens);
    }

    Collection<Token> allocate(InetAddressAndPort endpoint) {
        StrategyAdapter strategy = this.getOrCreateStrategy(endpoint);
        Collection<Token> tokens = strategy.createAllocator().addUnit(endpoint, this.numTokens);
        tokens = strategy.adjustForCrossDatacenterClashes(tokens);
        SummaryStatistics os = strategy.replicatedOwnershipStats();
        this.tokenMetadata.updateNormalTokens(tokens, endpoint);
        SummaryStatistics ns = strategy.replicatedOwnershipStats();
        logger.info("Selected tokens {}", tokens);
        logger.debug("Replicated node load in datacenter before allocation {}", (Object)TokenAllocation.statToString(os));
        logger.debug("Replicated node load in datacenter after allocation {}", (Object)TokenAllocation.statToString(ns));
        double stdDevGrowth = ns.getStandardDeviation() - os.getStandardDeviation();
        if (stdDevGrowth > 0.05) {
            logger.warn(String.format("Growth of %.2f%% in token ownership standard deviation after allocation above warning threshold of %d%%", stdDevGrowth * 100.0, 5));
        }
        return tokens;
    }

    static String statToString(SummaryStatistics stat) {
        return String.format("max %.2f min %.2f stddev %.4f", stat.getMax() / stat.getMean(), stat.getMin() / stat.getMean(), stat.getStandardDeviation());
    }

    SummaryStatistics getAllocationRingOwnership(String datacenter, String rack) {
        return this.getOrCreateStrategy(datacenter, rack).replicatedOwnershipStats();
    }

    SummaryStatistics getAllocationRingOwnership(InetAddressAndPort endpoint) {
        return this.getOrCreateStrategy(endpoint).replicatedOwnershipStats();
    }

    private StrategyAdapter getOrCreateStrategy(InetAddressAndPort endpoint) {
        String dc = this.replicationStrategy.snitch.getDatacenter(endpoint);
        String rack = this.replicationStrategy.snitch.getRack(endpoint);
        return this.getOrCreateStrategy(dc, rack);
    }

    private StrategyAdapter getOrCreateStrategy(String dc, String rack) {
        return this.strategyByRackDc.computeIfAbsent(dc, k -> new HashMap()).computeIfAbsent(rack, k -> this.createStrategy(dc, rack));
    }

    private StrategyAdapter createStrategy(String dc, String rack) {
        if (this.replicationStrategy instanceof NetworkTopologyStrategy) {
            return this.createStrategy(this.tokenMetadata, (NetworkTopologyStrategy)this.replicationStrategy, dc, rack);
        }
        if (this.replicationStrategy instanceof SimpleStrategy) {
            return this.createStrategy((SimpleStrategy)this.replicationStrategy);
        }
        throw new ConfigurationException("Token allocation does not support replication strategy " + this.replicationStrategy.getClass().getSimpleName());
    }

    private StrategyAdapter createStrategy(SimpleStrategy rs) {
        return this.createStrategy(rs.snitch, null, null, rs.getReplicationFactor().allReplicas, false);
    }

    private StrategyAdapter createStrategy(TokenMetadata tokenMetadata, NetworkTopologyStrategy strategy, String dc, String rack) {
        int racks;
        int replicas = strategy.getReplicationFactor((String)dc).allReplicas;
        TokenMetadata.Topology topology = tokenMetadata.getTopology();
        int n = racks = topology.getDatacenterRacks().get((Object)dc) != null && ((ImmutableMultimap)topology.getDatacenterRacks().get((Object)dc)).containsKey((Object)rack) ? ((ImmutableMultimap)topology.getDatacenterRacks().get((Object)dc)).asMap().size() : 1;
        if (replicas <= 1) {
            return this.createStrategy(strategy.snitch, dc, null, 1, false);
        }
        if (racks == replicas) {
            return this.createStrategy(strategy.snitch, dc, rack, 1, false);
        }
        if (racks > replicas) {
            return this.createStrategy(strategy.snitch, dc, null, replicas, true);
        }
        if (racks == 1) {
            return this.createStrategy(strategy.snitch, dc, null, replicas, false);
        }
        throw new ConfigurationException(String.format("Token allocation failed: the number of racks %d in datacenter %s is lower than its replication factor %d.", racks, dc, replicas));
    }

    private StrategyAdapter createStrategy(final IEndpointSnitch snitch, final String dc, final String rack, final int replicas, final boolean groupByRack) {
        return new StrategyAdapter(){

            @Override
            public int replicas() {
                return replicas;
            }

            @Override
            public Object getGroup(InetAddressAndPort unit) {
                return groupByRack ? snitch.getRack(unit) : unit;
            }

            @Override
            public boolean inAllocationRing(InetAddressAndPort other) {
                return !(dc != null && !dc.equals(snitch.getDatacenter(other)) || rack != null && !rack.equals(snitch.getRack(other)));
            }
        };
    }

    abstract class StrategyAdapter
    implements ReplicationStrategy<InetAddressAndPort> {
        StrategyAdapter() {
        }

        abstract boolean inAllocationRing(InetAddressAndPort var1);

        final TokenAllocator<InetAddressAndPort> createAllocator() {
            TreeMap<Token, InetAddressAndPort> sortedTokens = new TreeMap<Token, InetAddressAndPort>();
            for (Map.Entry<Token, InetAddressAndPort> en : TokenAllocation.this.tokenMetadata.getNormalAndBootstrappingTokenToEndpointMap().entrySet()) {
                if (!this.inAllocationRing(en.getValue())) continue;
                sortedTokens.put(en.getKey(), en.getValue());
            }
            return TokenAllocatorFactory.createTokenAllocator(sortedTokens, this, TokenAllocation.this.tokenMetadata.partitioner);
        }

        final Collection<Token> adjustForCrossDatacenterClashes(Collection<Token> tokens) {
            ArrayList filtered = Lists.newArrayListWithCapacity((int)tokens.size());
            for (Token t : tokens) {
                while (TokenAllocation.this.tokenMetadata.getEndpoint(t) != null) {
                    InetAddressAndPort other = TokenAllocation.this.tokenMetadata.getEndpoint(t);
                    if (this.inAllocationRing(other)) {
                        throw new ConfigurationException(String.format("Allocated token %s already assigned to node %s. Is another node also allocating tokens?", t, other));
                    }
                    t = t.nextValidToken();
                }
                filtered.add(t);
            }
            return filtered;
        }

        final SummaryStatistics replicatedOwnershipStats() {
            SummaryStatistics stat = new SummaryStatistics();
            for (Map.Entry<InetAddressAndPort, Double> en : this.evaluateReplicatedOwnership().entrySet()) {
                if (!this.inAllocationRing(en.getKey())) continue;
                stat.addValue(en.getValue() / (double)TokenAllocation.this.tokenMetadata.getTokens(en.getKey()).size());
            }
            return stat;
        }

        private Map<InetAddressAndPort, Double> evaluateReplicatedOwnership() {
            HashMap ownership = Maps.newHashMap();
            ArrayList<Token> sortedTokens = TokenAllocation.this.tokenMetadata.sortedTokens();
            if (sortedTokens.isEmpty()) {
                return ownership;
            }
            Iterator it = sortedTokens.iterator();
            Token current = (Token)it.next();
            while (it.hasNext()) {
                Token next = (Token)it.next();
                this.addOwnership(current, next, ownership);
                current = next;
            }
            this.addOwnership(current, (Token)sortedTokens.get(0), ownership);
            return ownership;
        }

        private void addOwnership(Token current, Token next, Map<InetAddressAndPort, Double> ownership) {
            double size = current.size(next);
            Token representative = current.getPartitioner().midpoint(current, next);
            Iterator<InetAddressAndPort> iterator = TokenAllocation.this.replicationStrategy.calculateNaturalReplicas(representative, TokenAllocation.this.tokenMetadata).endpoints().iterator();
            while (iterator.hasNext()) {
                InetAddressAndPort n;
                Double v = ownership.get(n = iterator.next());
                ownership.put(n, v != null ? v + size : size);
            }
        }
    }
}

