/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.analyzer.filter;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.cassandra.concurrent.ImmediateExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tartarus.snowball.SnowballStemmer;
import org.tartarus.snowball.ext.DanishStemmer;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FinnishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.GermanStemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.NorwegianStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;

public class StemmerFactory {
    private static final Logger logger = LoggerFactory.getLogger(StemmerFactory.class);
    private static final LoadingCache<Class, Constructor<?>> STEMMER_CONSTRUCTOR_CACHE = Caffeine.newBuilder().executor((Executor)ImmediateExecutor.INSTANCE).build(new CacheLoader<Class, Constructor<?>>(){

        public Constructor<?> load(Class aClass) throws Exception {
            try {
                return aClass.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                logger.error("Failed to get stemmer constructor", (Throwable)e);
                return null;
            }
        }
    });
    private static final Map<String, Class> SUPPORTED_LANGUAGES = new HashMap<String, Class>();

    public static SnowballStemmer getStemmer(Locale locale) {
        if (locale == null) {
            return null;
        }
        String rootLang = locale.getLanguage().substring(0, 2);
        try {
            Class clazz = SUPPORTED_LANGUAGES.get(rootLang);
            if (clazz == null) {
                return null;
            }
            Constructor ctor = (Constructor)STEMMER_CONSTRUCTOR_CACHE.get((Object)clazz);
            return (SnowballStemmer)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Failed to create new SnowballStemmer instance for language [{}]", (Object)locale.getLanguage(), (Object)e);
            return null;
        }
    }

    static {
        SUPPORTED_LANGUAGES.put("de", GermanStemmer.class);
        SUPPORTED_LANGUAGES.put("da", DanishStemmer.class);
        SUPPORTED_LANGUAGES.put("es", SpanishStemmer.class);
        SUPPORTED_LANGUAGES.put("en", EnglishStemmer.class);
        SUPPORTED_LANGUAGES.put("fl", FinnishStemmer.class);
        SUPPORTED_LANGUAGES.put("fr", FrenchStemmer.class);
        SUPPORTED_LANGUAGES.put("hu", HungarianStemmer.class);
        SUPPORTED_LANGUAGES.put("it", ItalianStemmer.class);
        SUPPORTED_LANGUAGES.put("nl", DutchStemmer.class);
        SUPPORTED_LANGUAGES.put("no", NorwegianStemmer.class);
        SUPPORTED_LANGUAGES.put("pt", PortugueseStemmer.class);
        SUPPORTED_LANGUAGES.put("ro", RomanianStemmer.class);
        SUPPORTED_LANGUAGES.put("ru", RussianStemmer.class);
        SUPPORTED_LANGUAGES.put("sv", SwedishStemmer.class);
        SUPPORTED_LANGUAGES.put("tr", TurkishStemmer.class);
    }
}

