/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.RangesAtEndpoint;
import org.apache.cassandra.utils.FBUtilities;

public final class Replica
implements Comparable<Replica> {
    private final Range<Token> range;
    private final InetAddressAndPort endpoint;
    private final boolean full;

    public Replica(InetAddressAndPort endpoint, Range<Token> range, boolean full) {
        Preconditions.checkNotNull((Object)endpoint);
        Preconditions.checkNotNull(range);
        this.endpoint = endpoint;
        this.range = range;
        this.full = full;
    }

    public Replica(InetAddressAndPort endpoint, Token start, Token end, boolean full) {
        this(endpoint, new Range<Token>(start, end), full);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Replica replica = (Replica)o;
        return this.full == replica.full && Objects.equals(this.endpoint, replica.endpoint) && Objects.equals(this.range, replica.range);
    }

    @Override
    public int compareTo(Replica o) {
        int c = this.range.compareTo(o.range);
        if (c == 0) {
            c = this.endpoint.compareTo(o.endpoint);
        }
        if (c == 0) {
            c = Boolean.compare(this.full, o.full);
        }
        return c;
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.range, this.full);
    }

    public String toString() {
        return (this.full ? "Full" : "Transient") + "(" + this.endpoint() + "," + this.range + ")";
    }

    public final InetAddressAndPort endpoint() {
        return this.endpoint;
    }

    public boolean isSelf() {
        return this.endpoint.equals(FBUtilities.getBroadcastAddressAndPort());
    }

    public Range<Token> range() {
        return this.range;
    }

    public final boolean isFull() {
        return this.full;
    }

    public final boolean isTransient() {
        return !this.isFull();
    }

    public RangesAtEndpoint subtractSameReplication(RangesAtEndpoint toSubtract) {
        Set<Range<Token>> subtractedRanges = this.range().subtractAll(((RangesAtEndpoint)toSubtract.filter(r -> r.isFull() == this.isFull())).ranges());
        RangesAtEndpoint.Builder result = RangesAtEndpoint.builder(this.endpoint, subtractedRanges.size());
        for (Range<Token> range : subtractedRanges) {
            result.add(this.decorateSubrange(range));
        }
        return result.build();
    }

    public RangesAtEndpoint subtractIgnoreTransientStatus(Range<Token> subtract) {
        Set<Range<Token>> ranges = this.range.subtract(subtract);
        RangesAtEndpoint.Builder result = RangesAtEndpoint.builder(this.endpoint, ranges.size());
        for (Range<Token> subrange : ranges) {
            result.add(this.decorateSubrange(subrange));
        }
        return result.build();
    }

    public boolean contains(Range<Token> that) {
        return this.range().contains((Token)((Object)that));
    }

    public boolean intersectsOnRange(Replica replica) {
        return this.range().intersects(replica.range());
    }

    public Replica decorateSubrange(Range<Token> subrange) {
        Preconditions.checkArgument((boolean)this.range.contains((Token)((Object)subrange)));
        return new Replica(this.endpoint(), subrange, this.isFull());
    }

    public static Replica fullReplica(InetAddressAndPort endpoint, Range<Token> range) {
        return new Replica(endpoint, range, true);
    }

    public static Replica fullReplica(InetAddressAndPort endpoint, Token start, Token end) {
        return Replica.fullReplica(endpoint, new Range<Token>(start, end));
    }

    public static Replica transientReplica(InetAddressAndPort endpoint, Range<Token> range) {
        return new Replica(endpoint, range, false);
    }

    public static Replica transientReplica(InetAddressAndPort endpoint, Token start, Token end) {
        return Replica.transientReplica(endpoint, new Range<Token>(start, end));
    }
}

