/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.repair.NoSuchRepairSessionException;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.RepairOutOfTokenRangeException;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.repair.StreamingRepairTask;
import org.apache.cassandra.repair.TableRepairManager;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.repair.messages.CleanupMessage;
import org.apache.cassandra.repair.messages.FailSession;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.StatusRequest;
import org.apache.cassandra.repair.messages.StatusResponse;
import org.apache.cassandra.repair.messages.SyncRequest;
import org.apache.cassandra.repair.messages.ValidationRequest;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.AbstractState;
import org.apache.cassandra.repair.state.Completable;
import org.apache.cassandra.repair.state.ParticipateState;
import org.apache.cassandra.repair.state.SyncState;
import org.apache.cassandra.repair.state.ValidationState;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.TimeUUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairMessageVerbHandler
implements IVerbHandler<RepairMessage> {
    private final SharedContext ctx;
    private static final Logger logger = LoggerFactory.getLogger(RepairMessageVerbHandler.class);

    public static RepairMessageVerbHandler instance() {
        return Holder.instance;
    }

    @VisibleForTesting
    public RepairMessageVerbHandler() {
        this(SharedContext.Global.instance);
    }

    public RepairMessageVerbHandler(SharedContext ctx) {
        this.ctx = ctx;
    }

    private boolean isIncremental(TimeUUID sessionID) {
        return this.ctx.repair().consistent.local.isSessionInProgress(sessionID);
    }

    private PreviewKind previewKind(TimeUUID sessionID) throws NoSuchRepairSessionException {
        ActiveRepairService.ParentRepairSession prs = this.ctx.repair().getParentRepairSession(sessionID);
        return prs != null ? prs.previewKind : PreviewKind.NONE;
    }

    @Override
    public void doVerb(Message<RepairMessage> message) {
        RepairJobDesc desc = ((RepairMessage)message.payload).desc;
        try {
            switch (message.verb()) {
                case PREPARE_MSG: {
                    PrepareMessage prepareMessage = (PrepareMessage)message.payload;
                    logger.debug("Preparing, {}", (Object)prepareMessage);
                    ParticipateState state = new ParticipateState(this.ctx.clock(), message.from(), prepareMessage);
                    if (!this.ctx.repair().register(state)) {
                        this.replyDedup(this.ctx.repair().participate((TimeUUID)state.id), message);
                        return;
                    }
                    if (!this.ctx.repair().verifyCompactionsPendingThreshold(prepareMessage.parentRepairSession, prepareMessage.previewKind)) {
                        state.phase.fail("Too many pending compactions");
                        this.sendFailureResponse(message);
                        return;
                    }
                    ArrayList<ColumnFamilyStore> columnFamilyStores = new ArrayList<ColumnFamilyStore>(prepareMessage.tableIds.size());
                    for (TableId tableId : prepareMessage.tableIds) {
                        ColumnFamilyStore columnFamilyStore = ColumnFamilyStore.getIfExists(tableId);
                        if (columnFamilyStore == null) {
                            String reason = String.format("Table with id %s was dropped during prepare phase of repair", tableId);
                            state.phase.fail(reason);
                            this.logErrorAndSendFailureResponse(reason, message);
                            return;
                        }
                        columnFamilyStores.add(columnFamilyStore);
                    }
                    state.phase.accept();
                    this.ctx.repair().registerParentRepairSession(prepareMessage.parentRepairSession, message.from(), columnFamilyStores, prepareMessage.ranges, prepareMessage.isIncremental, prepareMessage.repairedAt, prepareMessage.isGlobal, prepareMessage.previewKind);
                    this.sendAck(message);
                    break;
                }
                case SNAPSHOT_MSG: {
                    logger.debug("Snapshotting {}", (Object)desc);
                    ParticipateState state = this.ctx.repair().participate(desc.parentSessionId);
                    if (state == null) {
                        this.logErrorAndSendFailureResponse("Unknown repair " + desc.parentSessionId, message);
                        return;
                    }
                    ColumnFamilyStore cfs = ColumnFamilyStore.getIfExists(desc.keyspace, desc.columnFamily);
                    if (cfs == null) {
                        String reason = String.format("Table %s.%s was dropped during snapshot phase of repair %s", desc.keyspace, desc.columnFamily, desc.parentSessionId);
                        state.phase.fail(reason);
                        this.logErrorAndSendFailureResponse(reason, message);
                        return;
                    }
                    ActiveRepairService.ParentRepairSession prs = this.ctx.repair().getParentRepairSession(desc.parentSessionId);
                    if (prs.setHasSnapshots()) {
                        state.getOrCreateJob(desc).snapshot();
                        TableRepairManager repairManager = cfs.getRepairManager();
                        if (prs.isGlobal) {
                            repairManager.snapshot(desc.parentSessionId.toString(), prs.getRanges(), false);
                        } else {
                            repairManager.snapshot(desc.parentSessionId.toString(), desc.ranges, true);
                        }
                        logger.debug("Enqueuing response to snapshot request {} to {}", (Object)desc.sessionId, (Object)message.from());
                    }
                    this.sendAck(message);
                    break;
                }
                case VALIDATION_REQ: {
                    ValidationRequest validationRequest = (ValidationRequest)message.payload;
                    logger.debug("Validating {}", (Object)validationRequest);
                    ParticipateState participate = this.ctx.repair().participate(desc.parentSessionId);
                    if (participate == null) {
                        this.logErrorAndSendFailureResponse("Unknown repair " + desc.parentSessionId, message);
                        return;
                    }
                    ValidationState vState = new ValidationState(this.ctx.clock(), desc, message.from());
                    if (!this.register(message, participate, vState, participate::register, (d, i) -> participate.validation((RepairJobDesc)d))) {
                        return;
                    }
                    try {
                        PreviewKind previewKind;
                        ColumnFamilyStore store = ColumnFamilyStore.getIfExists(desc.keyspace, desc.columnFamily);
                        if (store == null) {
                            String msg = String.format("Table %s.%s was dropped during validation phase of repair %s", desc.keyspace, desc.columnFamily, desc.parentSessionId);
                            vState.phase.fail(msg);
                            this.logErrorAndSendFailureResponse(msg, message);
                            return;
                        }
                        try {
                            this.ctx.repair().consistent.local.maybeSetRepairing(desc.parentSessionId);
                        }
                        catch (Throwable t) {
                            JVMStabilityInspector.inspectThrowable(t);
                            vState.phase.fail(t.toString());
                            this.logErrorAndSendFailureResponse(t.toString(), message);
                            return;
                        }
                        try {
                            previewKind = this.previewKind(desc.parentSessionId);
                        }
                        catch (NoSuchRepairSessionException e) {
                            logger.warn("Parent repair session {} has been removed, failing repair", (Object)desc.parentSessionId);
                            vState.phase.fail(e);
                            this.sendFailureResponse(message);
                            return;
                        }
                        vState.phase.accept();
                        this.sendAck(message);
                        Validator validator = new Validator(this.ctx, vState, validationRequest.nowInSec, this.isIncremental(desc.parentSessionId), previewKind);
                        if (RepairMessageVerbHandler.acceptMessage(this.ctx, validationRequest, message.from())) {
                            this.ctx.validationManager().submitValidation(store, validator);
                            break;
                        }
                        validator.fail(new RepairOutOfTokenRangeException(validationRequest.desc.ranges));
                        break;
                    }
                    catch (Throwable t) {
                        vState.phase.fail(t);
                        throw t;
                    }
                }
                case SYNC_REQ: {
                    SyncRequest request = (SyncRequest)message.payload;
                    logger.debug("Syncing {}", (Object)request);
                    ParticipateState participate = this.ctx.repair().participate(desc.parentSessionId);
                    if (participate == null) {
                        this.logErrorAndSendFailureResponse("Unknown repair " + desc.parentSessionId, message);
                        return;
                    }
                    SyncState state = new SyncState(this.ctx.clock(), desc, request.initiator, request.src, request.dst);
                    if (!this.register(message, participate, state, participate::register, participate::sync)) {
                        return;
                    }
                    state.phase.accept();
                    StreamingRepairTask task = new StreamingRepairTask(this.ctx, state, desc, request.initiator, request.src, request.dst, request.ranges, this.isIncremental(desc.parentSessionId) ? desc.parentSessionId : null, request.previewKind, request.asymmetric);
                    task.run();
                    this.sendAck(message);
                    break;
                }
                case CLEANUP_MSG: {
                    logger.debug("cleaning up repair");
                    CleanupMessage cleanup = (CleanupMessage)message.payload;
                    ParticipateState state = this.ctx.repair().participate(cleanup.parentRepairSession);
                    if (state != null) {
                        state.phase.success("Cleanup message recieved");
                    }
                    this.ctx.repair().removeParentRepairSession(cleanup.parentRepairSession);
                    this.sendAck(message);
                    break;
                }
                case PREPARE_CONSISTENT_REQ: {
                    this.ctx.repair().consistent.local.handlePrepareMessage(message);
                    break;
                }
                case PREPARE_CONSISTENT_RSP: {
                    this.ctx.repair().consistent.coordinated.handlePrepareResponse(message);
                    break;
                }
                case FINALIZE_PROPOSE_MSG: {
                    this.ctx.repair().consistent.local.handleFinalizeProposeMessage(message);
                    break;
                }
                case FINALIZE_PROMISE_MSG: {
                    this.ctx.repair().consistent.coordinated.handleFinalizePromiseMessage(message);
                    break;
                }
                case FINALIZE_COMMIT_MSG: {
                    this.ctx.repair().consistent.local.handleFinalizeCommitMessage(message);
                    break;
                }
                case FAILED_SESSION_MSG: {
                    FailSession failure = (FailSession)message.payload;
                    this.sendAck(message);
                    ParticipateState p = this.ctx.repair().participate(failure.sessionID);
                    if (p != null) {
                        p.phase.fail("Failure message from " + message.from());
                    }
                    this.ctx.repair().consistent.coordinated.handleFailSessionMessage(failure);
                    this.ctx.repair().consistent.local.handleFailSessionMessage(message.from(), failure);
                    break;
                }
                case STATUS_REQ: {
                    this.ctx.repair().consistent.local.handleStatusRequest(message.from(), (StatusRequest)message.payload);
                    break;
                }
                case STATUS_RSP: {
                    this.ctx.repair().consistent.local.handleStatusResponse(message.from(), (StatusResponse)message.payload);
                    break;
                }
                default: {
                    this.ctx.repair().handleMessage(message);
                }
            }
        }
        catch (Exception e) {
            logger.error("Got error, removing parent repair session");
            if (desc != null && desc.parentSessionId != null) {
                ParticipateState parcipate = this.ctx.repair().participate(desc.parentSessionId);
                if (parcipate != null) {
                    parcipate.phase.fail(e);
                }
                this.ctx.repair().removeParentRepairSession(desc.parentSessionId);
            }
            throw new RuntimeException(e);
        }
    }

    private <I, T extends AbstractState<?, I>> boolean register(Message<RepairMessage> message, ParticipateState participate, T vState, Function<T, ParticipateState.RegisterStatus> register, BiFunction<RepairJobDesc, I, T> getter) {
        ParticipateState.RegisterStatus registerStatus = register.apply(vState);
        switch (registerStatus) {
            case ACCEPTED: {
                return true;
            }
            case EXISTS: {
                logger.debug("Duplicate validation message found for parent={}, validation={}", participate.id, vState.id);
                this.replyDedup((AbstractCompletable)getter.apply(((RepairMessage)message.payload).desc, vState.id), message);
                return false;
            }
            case ALREADY_COMPLETED: 
            case STATUS_REJECTED: {
                this.sendFailureResponse(message);
                return false;
            }
        }
        throw new IllegalStateException("Unexpected status: " + registerStatus);
    }

    private static DedupResult dedupResult(AbstractCompletable<?> state) {
        AbstractCompletable.Status status = state.getCompletionStatus();
        switch (status) {
            case INIT: {
                return DedupResult.UNKNOWN;
            }
            case ACCEPTED: {
                return DedupResult.ACCEPT;
            }
            case COMPLETED: {
                return state.getResult().kind == Completable.Result.Kind.FAILURE ? DedupResult.REJECT : DedupResult.ACCEPT;
            }
        }
        throw new IllegalStateException("Unknown status: " + state);
    }

    private void replyDedup(AbstractCompletable<?> state, Message<RepairMessage> message) {
        if (state == null) {
            throw new IllegalStateException("State is null");
        }
        DedupResult result = RepairMessageVerbHandler.dedupResult(state);
        switch (result) {
            case ACCEPT: {
                this.sendAck(message);
                break;
            }
            case REJECT: {
                this.sendFailureResponse(message);
                break;
            }
            case UNKNOWN: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown result: " + result);
            }
        }
    }

    private void logErrorAndSendFailureResponse(String errorMessage, Message<?> respondTo) {
        logger.error(errorMessage);
        this.sendFailureResponse(respondTo);
    }

    private void sendFailureResponse(Message<?> respondTo) {
        RepairMessage.sendFailureResponse(this.ctx, respondTo);
    }

    private void sendAck(Message<RepairMessage> message) {
        RepairMessage.sendAck(this.ctx, message);
    }

    private static boolean acceptMessage(SharedContext ctx, ValidationRequest validationRequest, InetAddressAndPort from) {
        boolean outOfRangeTokenLogging = DatabaseDescriptor.getLogOutOfTokenRangeRequests();
        boolean outOfRangeTokenRejection = DatabaseDescriptor.getRejectOutOfTokenRangeRequests();
        if (!outOfRangeTokenLogging && !outOfRangeTokenRejection) {
            return true;
        }
        return StorageService.instance.getNormalizedRanges(validationRequest.desc.keyspace, ctx.broadcastAddressAndPort()).validateRangeRequest(validationRequest.desc.ranges, "RepairSession #" + validationRequest.desc.parentSessionId, "validation request", from);
    }

    private static enum DedupResult {
        UNKNOWN,
        ACCEPT,
        REJECT;

    }

    private static class Holder {
        private static final RepairMessageVerbHandler instance = new RepairMessageVerbHandler();

        private Holder() {
        }
    }
}

