/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.TopPartitionTracker;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.repair.messages.ValidationResponse;
import org.apache.cassandra.repair.state.ValidationState;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MerkleTree;
import org.apache.cassandra.utils.MerkleTrees;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Validator.class);
    public final RepairJobDesc desc;
    public final InetAddressAndPort initiator;
    public final long nowInSec;
    private final boolean evenTreeDistribution;
    public final boolean isIncremental;
    public final SharedContext ctx;
    private long validated;
    private MerkleTrees trees;
    private MerkleTree.TreeRange range;
    private MerkleTrees.TreeRangeIterator ranges;
    private DecoratedKey lastKey;
    private final PreviewKind previewKind;
    public final ValidationState state;
    public TopPartitionTracker.Collector topPartitionCollector;

    public Validator(ValidationState state, long nowInSec, PreviewKind previewKind) {
        this(SharedContext.Global.instance, state, nowInSec, false, false, previewKind);
    }

    public Validator(SharedContext ctx, ValidationState state, long nowInSec, boolean isIncremental, PreviewKind previewKind) {
        this(ctx, state, nowInSec, false, isIncremental, previewKind);
    }

    public Validator(ValidationState state, long nowInSec, boolean isIncremental, PreviewKind previewKind) {
        this(SharedContext.Global.instance, state, nowInSec, false, isIncremental, previewKind);
    }

    public Validator(SharedContext ctx, ValidationState state, long nowInSec, boolean evenTreeDistribution, boolean isIncremental, PreviewKind previewKind) {
        this.ctx = ctx;
        this.state = state;
        this.desc = state.desc;
        this.initiator = state.initiator;
        this.nowInSec = nowInSec;
        this.isIncremental = isIncremental;
        this.previewKind = previewKind;
        this.validated = 0L;
        this.range = null;
        this.ranges = null;
        this.evenTreeDistribution = evenTreeDistribution;
    }

    public void prepare(ColumnFamilyStore cfs, MerkleTrees trees, TopPartitionTracker.Collector topPartitionCollector) {
        this.trees = trees;
        this.topPartitionCollector = topPartitionCollector;
        if (!trees.partitioner().preservesOrder() || this.evenTreeDistribution) {
            trees.init();
        } else {
            ArrayList<DecoratedKey> keys = new ArrayList<DecoratedKey>();
            Random random = this.ctx.random().get();
            for (Range<Token> range : trees.ranges()) {
                DecoratedKey dk;
                for (DecoratedKey sample : cfs.keySamples(range)) {
                    assert (range.contains(sample.getToken())) : "Token " + sample.getToken() + " is not within range " + this.desc.ranges;
                    keys.add(sample);
                }
                if (keys.isEmpty()) {
                    trees.init(range);
                    continue;
                }
                int numKeys = keys.size();
                while (trees.split((dk = (DecoratedKey)keys.get(random.nextInt(numKeys))).getToken())) {
                }
                keys.clear();
            }
        }
        logger.debug("Prepared AEService trees of size {} for {}", (Object)this.trees.size(), (Object)this.desc);
        this.ranges = trees.rangeIterator();
    }

    public void add(UnfilteredRowIterator partition) {
        assert (Range.isInRanges(partition.partitionKey().getToken(), this.desc.ranges)) : partition.partitionKey().getToken() + " is not contained in " + this.desc.ranges;
        assert (this.lastKey == null || this.lastKey.compareTo(partition.partitionKey()) < 0) : "partition " + partition.partitionKey() + " received out of order wrt " + this.lastKey;
        this.lastKey = partition.partitionKey();
        if (this.range == null) {
            this.range = (MerkleTree.TreeRange)this.ranges.next();
        }
        if (!this.findCorrectRange(this.lastKey.getToken())) {
            this.ranges = this.trees.rangeIterator();
            this.findCorrectRange(this.lastKey.getToken());
        }
        assert (this.range.contains(this.lastKey.getToken())) : "Token not in MerkleTree: " + this.lastKey.getToken();
        MerkleTree.RowHash rowHash = this.rowHash(partition);
        if (rowHash != null) {
            if (this.topPartitionCollector != null) {
                this.topPartitionCollector.trackPartitionSize(partition.partitionKey(), rowHash.size);
            }
            this.range.addHash(rowHash);
        }
    }

    public boolean findCorrectRange(Token t) {
        while (!this.range.contains(t) && this.ranges.hasNext()) {
            this.range = (MerkleTree.TreeRange)this.ranges.next();
        }
        return this.range.contains(t);
    }

    private MerkleTree.RowHash rowHash(UnfilteredRowIterator partition) {
        ++this.validated;
        Digest digest = Digest.forValidator();
        UnfilteredRowIterators.digest(partition, digest, MessagingService.current_version);
        return digest.inputBytes() > 0L ? new MerkleTree.RowHash(partition.partitionKey().getToken(), digest.digest(), digest.inputBytes()) : null;
    }

    public void complete() {
        assert (this.ranges != null) : "Validator was not prepared()";
        if (logger.isDebugEnabled()) {
            logger.debug("Validated {} partitions for {}.  Partitions per leaf are:", (Object)this.validated, (Object)this.desc.sessionId);
            this.trees.logRowCountPerLeaf(logger);
            logger.debug("Validated {} partitions for {}.  Partition sizes are:", (Object)this.validated, (Object)this.desc.sessionId);
            this.trees.logRowSizePerLeaf(logger);
        }
        this.state.phase.sendingTrees();
        Stage.ANTI_ENTROPY.execute(this);
    }

    public void fail(Throwable e) {
        this.state.phase.fail(e);
        this.respond(new ValidationResponse(this.desc));
    }

    @Override
    public void run() {
        if (this.initiatorIsRemote()) {
            logger.info("{} Sending completed merkle tree to {} for {}.{}", new Object[]{this.previewKind.logPrefix(this.desc.sessionId), this.initiator, this.desc.keyspace, this.desc.columnFamily});
            Tracing.traceRepair("Sending completed merkle tree to {} for {}.{}", this.initiator, this.desc.keyspace, this.desc.columnFamily);
        } else {
            logger.info("{} Local completed merkle tree for {} for {}.{}", new Object[]{this.previewKind.logPrefix(this.desc.sessionId), this.initiator, this.desc.keyspace, this.desc.columnFamily});
            Tracing.traceRepair("Local completed merkle tree for {} for {}.{}", this.initiator, this.desc.keyspace, this.desc.columnFamily);
        }
        this.state.phase.success();
        this.respond(new ValidationResponse(this.desc, this.trees));
    }

    public PreviewKind getPreviewKind() {
        return this.previewKind;
    }

    private boolean initiatorIsRemote() {
        return !FBUtilities.getBroadcastAddressAndPort().equals(this.initiator);
    }

    @VisibleForTesting
    void respond(ValidationResponse response) {
        if (this.initiatorIsRemote()) {
            RepairMessage.sendMessageWithRetries(this.ctx, response, Verb.VALIDATION_RSP, this.initiator);
            return;
        }
        Stage.ANTI_ENTROPY.execute(() -> {
            ValidationResponse movedResponse = response;
            try {
                movedResponse = response.tryMoveOffHeap();
            }
            catch (IOException e) {
                logger.error("Failed to move local merkle tree for {} off heap", (Object)this.desc, (Object)e);
            }
            this.ctx.repair().handleMessage(Message.out(Verb.VALIDATION_RSP, movedResponse));
        });
    }
}

