/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.utils.CassandraUInt;

public class ValidationRequest
extends RepairMessage {
    public final long nowInSec;
    public static final IVersionedSerializer<ValidationRequest> serializer = new IVersionedSerializer<ValidationRequest>(){

        @Override
        public void serialize(ValidationRequest message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            out.writeInt(version >= 13 ? CassandraUInt.fromLong(message.nowInSec) : (int)message.nowInSec);
        }

        @Override
        public ValidationRequest deserialize(DataInputPlus dis, int version) throws IOException {
            RepairJobDesc desc = (RepairJobDesc)RepairJobDesc.serializer.deserialize(dis, version);
            long nowInsec = version >= 13 ? CassandraUInt.toLong(dis.readInt()) : (long)dis.readInt();
            return new ValidationRequest(desc, nowInsec);
        }

        @Override
        public long serializedSize(ValidationRequest message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            return size += 4L;
        }
    };

    public ValidationRequest(RepairJobDesc desc, long nowInSec) {
        super(desc);
        this.nowInSec = nowInSec;
    }

    public String toString() {
        return "ValidationRequest{nowInSec=" + this.nowInSec + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationRequest that = (ValidationRequest)o;
        return this.nowInSec == that.nowInSec;
    }

    public int hashCode() {
        return (int)this.nowInSec;
    }
}

