/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cassandra.concurrent.ExecutorLocals;

public class ClientWarn
extends ExecutorLocals.Impl {
    private static final String TRUNCATED = " [truncated]";
    public static ClientWarn instance = new ClientWarn();

    private ClientWarn() {
    }

    public State get() {
        return ExecutorLocals.current().clientWarnState;
    }

    public void set(State value) {
        ExecutorLocals current = ExecutorLocals.current();
        ExecutorLocals.Impl.set(current.traceState, value);
    }

    public void warn(String text) {
        State state = this.get();
        if (state != null) {
            state.add(text);
        }
    }

    public void captureWarnings() {
        this.set(new State());
    }

    public List<String> getWarnings() {
        State state = this.get();
        if (state == null || state.warnings.isEmpty()) {
            return null;
        }
        return state.warnings;
    }

    public void resetWarnings() {
        this.set(null);
    }

    public static class State {
        private final List<String> warnings = new CopyOnWriteArrayList<String>();

        private void add(String warning) {
            if (this.warnings.size() < 65535) {
                this.warnings.add(State.maybeTruncate(warning));
            }
        }

        private static String maybeTruncate(String warning) {
            return warning.length() > 65535 ? warning.substring(0, 65535 - ClientWarn.TRUNCATED.length()) + ClientWarn.TRUNCATED : warning;
        }
    }
}

