/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.StressProfile;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.generate.TokenRangeIterator;
import org.apache.cassandra.stress.operations.OpDistributionFactory;
import org.apache.cassandra.stress.operations.SampledOpDistributionFactory;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionAnyProbabilities;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.ResultLogger;

public class SettingsCommandUser
extends SettingsCommand {
    private final Map<String, Double> ratios;
    private final DistributionFactory clustering;
    public final Map<String, StressProfile> profiles;
    private final Options options;
    private String default_profile_name;
    private static final Pattern EXTRACT_SPEC_CMD = Pattern.compile("(.+)\\.(.+)");

    public SettingsCommandUser(Options options) {
        super(Command.USER, options.parent);
        String[] yamlPaths;
        this.options = options;
        this.clustering = options.clustering.get();
        this.ratios = options.ops.ratios();
        this.default_profile_name = null;
        String yamlPath = options.profile.value();
        this.profiles = new LinkedHashMap<String, StressProfile>();
        for (String curYamlPath : yamlPaths = yamlPath.split(",")) {
            URI yamlURI;
            File yamlFile = new File(curYamlPath);
            if (yamlFile.exists()) {
                yamlURI = yamlFile.toURI();
            } else {
                yamlURI = URI.create(curYamlPath);
                String uriScheme = yamlURI.getScheme();
                if (uriScheme == null || "file".equals(uriScheme)) {
                    throw new IllegalArgumentException("File '" + yamlURI.getPath() + "' doesn't exist!");
                }
            }
            StressProfile profile = StressProfile.load(yamlURI);
            String specName = profile.specName;
            if (this.default_profile_name == null) {
                this.default_profile_name = specName;
            }
            if (this.profiles.containsKey(specName)) {
                throw new IllegalArgumentException("Must only specify a singe YAML file per table (including keyspace qualifier).");
            }
            this.profiles.put(specName, profile);
        }
        if (this.ratios.size() == 0) {
            throw new IllegalArgumentException("Must specify at least one command with a non-zero ratio");
        }
    }

    public boolean hasInsertOnly() {
        return this.ratios.size() == 1 && this.ratios.containsKey("insert");
    }

    @Override
    public OpDistributionFactory getFactory(final StressSettings settings) {
        final SeedManager seeds = new SeedManager(settings);
        final LinkedHashMap tokenRangeIterators = new LinkedHashMap();
        this.profiles.forEach((k, v) -> tokenRangeIterators.put(k, v.tokenRangeQueries.isEmpty() ? null : new TokenRangeIterator(settings, v.maybeLoadTokenRanges(settings))));
        return new SampledOpDistributionFactory<String>(this.ratios, this.clustering){

            @Override
            protected List<? extends Operation> get(Timer timer, String key, boolean isWarmup) {
                String sub_key;
                String profile_name;
                Matcher m = EXTRACT_SPEC_CMD.matcher(key);
                if (m.matches()) {
                    profile_name = m.group(1);
                    sub_key = m.group(2);
                } else {
                    profile_name = SettingsCommandUser.this.default_profile_name;
                    sub_key = key;
                }
                if (!SettingsCommandUser.this.profiles.containsKey(profile_name)) {
                    throw new IllegalArgumentException(String.format("Op name %s contains an invalid profile specname: %s", key, profile_name));
                }
                StressProfile profile = SettingsCommandUser.this.profiles.get(profile_name);
                TokenRangeIterator tokenRangeIterator = (TokenRangeIterator)tokenRangeIterators.get(profile_name);
                PartitionGenerator generator = profile.newGenerator(settings);
                if (sub_key.equalsIgnoreCase("insert")) {
                    return Collections.singletonList(profile.getInsert(timer, generator, seeds, settings));
                }
                if (sub_key.equalsIgnoreCase("validate")) {
                    return profile.getValidate(timer, generator, seeds, settings);
                }
                if (profile.tokenRangeQueries.containsKey(sub_key)) {
                    return Collections.singletonList(profile.getBulkReadQueries(sub_key, timer, settings, tokenRangeIterator, isWarmup));
                }
                return Collections.singletonList(profile.getQuery(sub_key, timer, generator, seeds, settings, isWarmup));
            }
        };
    }

    @Override
    public void truncateTables(StressSettings settings) {
        this.profiles.forEach((k, v) -> v.truncateTable(settings));
    }

    @Override
    public void printSettings(ResultLogger out) {
        super.printSettings(out);
        out.printf("  Command Ratios: %s%n", this.ratios);
        out.printf("  Command Clustering Distribution: %s%n", this.options.clustering.getOptionAsString());
        out.printf("  Profile File(s): %s%n", this.options.profile.value());
    }

    public static SettingsCommandUser build(String[] params) {
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options(new SettingsCommand.Uncertainty()), new Options(new SettingsCommand.Duration()), new Options(new SettingsCommand.Count())});
        if (options == null) {
            SettingsCommandUser.printHelp();
            System.out.println("Invalid USER options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsCommandUser((Options)options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "user", new Options(new SettingsCommand.Uncertainty()), new Options(new SettingsCommand.Count()), new Options(new SettingsCommand.Duration()));
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsCommandUser.printHelp();
            }
        };
    }

    static final class Options
    extends GroupedOptions {
        final SettingsCommand.Options parent;
        final OptionDistribution clustering = new OptionDistribution("clustering=", "gaussian(1..10)", "Distribution clustering runs of operations of the same kind");
        final OptionSimple profile = new OptionSimple("profile=", ".*", null, "Specify the path to a yaml cql3 profile. Multiple comma separated files can be added.", true);
        final OptionAnyProbabilities ops = new OptionAnyProbabilities("ops", "Specify the ratios for inserts/queries to perform; e.g. ops(insert=2,<query1>=1) will perform 2 inserts for each query1. When using multiple files, specify as keyspace.table.op.");

        protected Options(SettingsCommand.Options parent) {
            this.parent = parent;
        }

        @Override
        public List<? extends Option> options() {
            return Options.merge(Arrays.asList(this.ops, this.profile, this.clustering), this.parent.options());
        }
    }
}

