/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.event.ProcedureParameterEvent;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;

public class RemoveProcedureParameterAction
extends RemoveAction {
    private static final String ACTION_NAME = "Remove Parameter";
    private static final String ACTION_NAME_MULTIPLE = "Remove Parameters";

    public static String getActionName(boolean multiple) {
        return multiple ? ACTION_NAME_MULTIPLE : ACTION_NAME;
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public RemoveProcedureParameterAction(Application application) {
        super(ACTION_NAME, application);
    }

    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return object instanceof ProcedureParameter;
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        ProcedureParameter[] params = this.getProjectController().getCurrentProcedureParameters();
        if (params.length > 0 && (params.length == 1 && dialog.shouldDelete("procedure parameter", params[0].getName()) || params.length > 1 && dialog.shouldDelete("selected procedure parameters"))) {
            this.removeProcedureParameters();
        }
    }

    protected void removeProcedureParameters() {
        ProjectController mediator = this.getProjectController();
        ProcedureParameter[] parameters = mediator.getCurrentProcedureParameters();
        this.removeProcedureParameters(mediator.getCurrentProcedure(), parameters);
    }

    public void removeProcedureParameters(Procedure procedure, ProcedureParameter[] parameters) {
        ProjectController mediator = this.getProjectController();
        for (ProcedureParameter parameter : parameters) {
            procedure.removeCallParameter(parameter.getName());
            ProcedureParameterEvent e = new ProcedureParameterEvent((Object)Application.getFrame(), parameter, 3);
            mediator.fireProcedureParameterEvent(e);
        }
    }
}

