/* Generated By:JJTree&JavaCC: Do not edit this line. ExpressionParserTokenManager.java */
/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/


package org.apache.cayenne.exp.parser;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.cayenne.exp.Expression;

/** Token Manager. */
public class ExpressionParserTokenManager implements ExpressionParserConstants
{
      /** Holds the last value computed by a constant token. */
    Object literalValue;

      /** Holds the last string literal parsed. */
    private StringBuffer stringBuffer;

      /** Converts an escape sequence into a character value. */
    private char escapeChar()
    {
        int ofs = image.length() - 1;
        switch ( image.charAt(ofs) ) {
            case 'n':   return '\u005cn';
            case 'r':   return '\u005cr';
            case 't':   return '\u005ct';
            case 'b':   return '\u005cb';
            case 'f':   return '\u005cf';
            case '\u005c\u005c':  return '\u005c\u005c';
            case '\u005c'':  return '\u005c'';
            case '\u005c"':  return '\u005c"';
        }

          // Otherwise, it's an octal number.  Find the backslash and convert.
        while ( image.charAt(--ofs) != '\u005c\u005c' )
          {}
        int value = 0;
        while ( ++ofs < image.length() )
            value = (value << 3) | (image.charAt(ofs) - '0');
        return (char) value;
    }

    private Object makeInt()
    {
        Object  result;
        String  s = image.toString();
        int     base = 10;

        if ( s.charAt(0) == '0' )
            base = (s.length() > 1 && (s.charAt(1) == 'x' || s.charAt(1) == 'X'))? 16 : 8;
        if ( base == 16 )
            s = s.substring(2); // Trim the 0x off the front
        switch ( s.charAt(s.length()-1) ) {
            case 'l': case 'L':
                result = Long.valueOf( s.substring(0,s.length()-1), base );
                break;

            case 'h': case 'H':
                result = new BigInteger( s.substring(0,s.length()-1), base );
                break;

            default:
                result = Integer.valueOf( s, base );
                break;
        }
        return result;
    }

    private Object makeFloat()
    {
        String s = image.toString();
        switch ( s.charAt(s.length()-1) ) {
            case 'f': case 'F':
                return Float.valueOf( s );

            case 'b': case 'B':
                return new BigDecimal( s.substring(0,s.length()-1) );

            case 'd': case 'D':
            default:
                return Double.valueOf( s );
        }
    }

  /** Debug output. */
  public  java.io.PrintStream debugStream = System.out;
  /** Set debug output. */
  public  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private final int jjStopStringLiteralDfa_0(int pos, long active0, long active1)
{
   switch (pos)
   {
      case 0:
         if ((active0 & 0x18030000000000L) != 0L)
         {
            jjmatchedKind = 69;
            return 36;
         }
         if ((active0 & 0x80000000000L) != 0L)
         {
            jjmatchedKind = 69;
            return 6;
         }
         if ((active0 & 0x8L) != 0L)
         {
            jjmatchedKind = 69;
            return 63;
         }
         if ((active0 & 0xffc7f4f00004e006L) != 0L || (active1 & 0xeL) != 0L)
         {
            jjmatchedKind = 69;
            return 74;
         }
         return -1;
      case 1:
         if ((active0 & 0x18000000000000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 1;
            return 35;
         }
         if ((active0 & 0x8002L) != 0L)
            return 74;
         if ((active0 & 0x80000000000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 1;
            return 5;
         }
         if ((active0 & 0x8L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 1;
            return 64;
         }
         if ((active0 & 0xffc7f7f000046004L) != 0L || (active1 & 0xeL) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 1;
            return 74;
         }
         return -1;
      case 2:
         if ((active0 & 0x5e0500f00000000cL) != 0L)
            return 74;
         if ((active0 & 0xa1c2ff0000046000L) != 0L || (active1 & 0xaL) != 0L)
         {
            if (jjmatchedPos != 2)
            {
               jjmatchedKind = 69;
               jjmatchedPos = 2;
            }
            return 74;
         }
         if ((active0 & 0x18000000000000L) != 0L)
         {
            if (jjmatchedPos != 2)
            {
               jjmatchedKind = 69;
               jjmatchedPos = 2;
            }
            return 34;
         }
         return -1;
      case 3:
         if ((active0 & 0x2142080000006000L) != 0L)
            return 74;
         if ((active0 & 0x18000000000000L) != 0L)
         {
            if (jjmatchedPos != 3)
            {
               jjmatchedKind = 69;
               jjmatchedPos = 3;
            }
            return 33;
         }
         if ((active0 & 0xda80f70000040000L) != 0L || (active1 & 0x8L) != 0L)
         {
            if (jjmatchedPos != 3)
            {
               jjmatchedKind = 69;
               jjmatchedPos = 3;
            }
            return 74;
         }
         return -1;
      case 4:
         if ((active0 & 0x80310000000000L) != 0L)
            return 74;
         if ((active0 & 0x18000000000000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 4;
            return 32;
         }
         if ((active0 & 0xda00c60000044000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 4;
            return 74;
         }
         return -1;
      case 5:
         if ((active0 & 0x18000000000000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 5;
            return 31;
         }
         if ((active0 & 0xc000c20000000000L) != 0L)
            return 74;
         if ((active0 & 0x1a00040000044000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 5;
            return 74;
         }
         return -1;
      case 6:
         if ((active0 & 0x18000000000000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 6;
            return 30;
         }
         if ((active0 & 0x40000L) != 0L)
            return 74;
         if ((active0 & 0x1a00040000004000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 6;
            return 74;
         }
         return -1;
      case 7:
         if ((active0 & 0x1a08040000004000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 7;
            return 74;
         }
         if ((active0 & 0x10000000000000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 7;
            return 29;
         }
         return -1;
      case 8:
         if ((active0 & 0x1200040000000000L) != 0L)
            return 74;
         if ((active0 & 0x10000000000000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 8;
            return 28;
         }
         if ((active0 & 0x808000000004000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 8;
            return 74;
         }
         return -1;
      case 9:
         if ((active0 & 0x800000000000000L) != 0L)
            return 74;
         if ((active0 & 0x10000000000000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 9;
            return 27;
         }
         if ((active0 & 0x8000000004000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 9;
            return 74;
         }
         return -1;
      case 10:
         if ((active0 & 0x10000000000000L) != 0L)
            return 26;
         if ((active0 & 0x8000000000000L) != 0L)
            return 74;
         if ((active0 & 0x4000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 10;
            return 74;
         }
         return -1;
      case 11:
         if ((active0 & 0x4000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 11;
            return 74;
         }
         return -1;
      case 12:
         if ((active0 & 0x4000L) != 0L)
         {
            jjmatchedKind = 69;
            jjmatchedPos = 12;
            return 74;
         }
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_0(int pos, long active0, long active1)
{
   return jjMoveNfa_0(jjStopStringLiteralDfa_0(pos, active0, active1), pos + 1);
}
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_0()
{
   switch(curChar)
   {
      case 33:
         jjmatchedKind = 4;
         return jjMoveStringLiteralDfa1_0(0x80L, 0x0L);
      case 34:
         return jjStopAtPos(0, 74);
      case 36:
         return jjStopAtPos(0, 64);
      case 38:
         return jjStopAtPos(0, 22);
      case 39:
         return jjStopAtPos(0, 73);
      case 40:
         return jjStopAtPos(0, 16);
      case 41:
         return jjStopAtPos(0, 17);
      case 42:
         return jjStopAtPos(0, 68);
      case 43:
         return jjStopAtPos(0, 25);
      case 44:
         return jjStopAtPos(0, 19);
      case 45:
         return jjStopAtPos(0, 26);
      case 47:
         return jjStopAtPos(0, 27);
      case 60:
         jjmatchedKind = 10;
         return jjMoveStringLiteralDfa1_0(0x800300L, 0x0L);
      case 61:
         jjmatchedKind = 5;
         return jjMoveStringLiteralDfa1_0(0x40L, 0x0L);
      case 62:
         jjmatchedKind = 11;
         return jjMoveStringLiteralDfa1_0(0x1001000L, 0x0L);
      case 94:
         return jjStopAtPos(0, 21);
      case 97:
         return jjMoveStringLiteralDfa1_0(0x1001000000004L, 0x0L);
      case 98:
         return jjMoveStringLiteralDfa1_0(0x40000L, 0x0L);
      case 99:
         return jjMoveStringLiteralDfa1_0(0x18030000000000L, 0x0L);
      case 100:
         return jjMoveStringLiteralDfa1_0(0x1e00000000000000L, 0x4L);
      case 101:
         return jjMoveStringLiteralDfa1_0(0x0L, 0x8L);
      case 104:
         return jjMoveStringLiteralDfa1_0(0x2000000000000000L, 0x0L);
      case 105:
         return jjMoveStringLiteralDfa1_0(0x8000L, 0x0L);
      case 108:
         return jjMoveStringLiteralDfa1_0(0xd00000006000L, 0x0L);
      case 109:
         return jjMoveStringLiteralDfa1_0(0x4084006000000000L, 0x0L);
      case 110:
         return jjMoveStringLiteralDfa1_0(0x8L, 0x0L);
      case 111:
         return jjMoveStringLiteralDfa1_0(0x2L, 0x2L);
      case 115:
         return jjMoveStringLiteralDfa1_0(0x8002048000000000L, 0x0L);
      case 116:
         return jjMoveStringLiteralDfa1_0(0x80000000000L, 0x0L);
      case 117:
         return jjMoveStringLiteralDfa1_0(0x200000000000L, 0x0L);
      case 119:
         return jjMoveStringLiteralDfa1_0(0x100000000000000L, 0x0L);
      case 121:
         return jjMoveStringLiteralDfa1_0(0x40000000000000L, 0x0L);
      case 124:
         return jjStopAtPos(0, 20);
      case 126:
         return jjStopAtPos(0, 28);
      default :
         return jjMoveNfa_0(3, 0);
   }
}
private int jjMoveStringLiteralDfa1_0(long active0, long active1)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(0, active0, active1);
      return 1;
   }
   switch(curChar)
   {
      case 60:
         if ((active0 & 0x800000L) != 0L)
            return jjStopAtPos(1, 23);
         break;
      case 61:
         if ((active0 & 0x40L) != 0L)
            return jjStopAtPos(1, 6);
         else if ((active0 & 0x80L) != 0L)
            return jjStopAtPos(1, 7);
         else if ((active0 & 0x200L) != 0L)
            return jjStopAtPos(1, 9);
         else if ((active0 & 0x1000L) != 0L)
            return jjStopAtPos(1, 12);
         break;
      case 62:
         if ((active0 & 0x100L) != 0L)
            return jjStopAtPos(1, 8);
         else if ((active0 & 0x1000000L) != 0L)
            return jjStopAtPos(1, 24);
         break;
      case 97:
         return jjMoveStringLiteralDfa2_0(active0, 0x1e00004000000000L, active1, 0L);
      case 98:
         return jjMoveStringLiteralDfa2_0(active0, 0x1000000000000L, active1, 0x6L);
      case 101:
         return jjMoveStringLiteralDfa2_0(active0, 0x8140400000040000L, active1, 0L);
      case 105:
         return jjMoveStringLiteralDfa2_0(active0, 0x4000002000006000L, active1, 0L);
      case 110:
         if ((active0 & 0x8000L) != 0L)
            return jjStartNfaWithStates_0(1, 15, 74);
         return jjMoveStringLiteralDfa2_0(active0, 0x4L, active1, 0x8L);
      case 111:
         return jjMoveStringLiteralDfa2_0(active0, 0x2084930000000008L, active1, 0L);
      case 112:
         return jjMoveStringLiteralDfa2_0(active0, 0x200000000000L, active1, 0L);
      case 113:
         return jjMoveStringLiteralDfa2_0(active0, 0x2000000000000L, active1, 0L);
      case 114:
         if ((active0 & 0x2L) != 0L)
            return jjStartNfaWithStates_0(1, 1, 74);
         return jjMoveStringLiteralDfa2_0(active0, 0x80000000000L, active1, 0L);
      case 117:
         return jjMoveStringLiteralDfa2_0(active0, 0x18048000000000L, active1, 0L);
      case 118:
         return jjMoveStringLiteralDfa2_0(active0, 0x1000000000L, active1, 0L);
      default :
         break;
   }
   return jjStartNfa_0(0, active0, active1);
}
private int jjMoveStringLiteralDfa2_0(long old0, long active0, long old1, long active1)
{
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_0(0, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(1, active0, active1);
      return 2;
   }
   switch(curChar)
   {
      case 58:
         if ((active1 & 0x4L) != 0L)
            return jjStopAtPos(2, 66);
         break;
      case 97:
         return jjMoveStringLiteralDfa3_0(active0, 0x40000000000000L, active1, 0L);
      case 98:
         return jjMoveStringLiteralDfa3_0(active0, 0x40000000000L, active1, 0L);
      case 99:
         return jjMoveStringLiteralDfa3_0(active0, 0x8000800000000000L, active1, 0L);
      case 100:
         if ((active0 & 0x4L) != 0L)
            return jjStartNfaWithStates_0(2, 2, 74);
         else if ((active0 & 0x4000000000000L) != 0L)
            return jjStartNfaWithStates_0(2, 50, 74);
         break;
      case 101:
         return jjMoveStringLiteralDfa3_0(active0, 0x100000000000000L, active1, 0L);
      case 103:
         if ((active0 & 0x1000000000L) != 0L)
            return jjStartNfaWithStates_0(2, 36, 74);
         break;
      case 105:
         return jjMoveStringLiteralDfa3_0(active0, 0x80000000000L, active1, 0L);
      case 106:
         return jjMoveStringLiteralDfa3_0(active0, 0L, active1, 0x2L);
      case 107:
         return jjMoveStringLiteralDfa3_0(active0, 0x6000L, active1, 0L);
      case 109:
         if ((active0 & 0x8000000000L) != 0L)
            return jjStartNfaWithStates_0(2, 39, 74);
         break;
      case 110:
         if ((active0 & 0x2000000000L) != 0L)
         {
            jjmatchedKind = 37;
            jjmatchedPos = 2;
         }
         return jjMoveStringLiteralDfa3_0(active0, 0x4080420000000000L, active1, 0L);
      case 112:
         return jjMoveStringLiteralDfa3_0(active0, 0x200000000000L, active1, 0L);
      case 114:
         return jjMoveStringLiteralDfa3_0(active0, 0x1a000000000000L, active1, 0L);
      case 115:
         if ((active0 & 0x1000000000000L) != 0L)
            return jjStartNfaWithStates_0(2, 48, 74);
         break;
      case 116:
         if ((active0 & 0x8L) != 0L)
            return jjStartNfaWithStates_0(2, 3, 74);
         return jjMoveStringLiteralDfa3_0(active0, 0x40000L, active1, 0L);
      case 117:
         return jjMoveStringLiteralDfa3_0(active0, 0x2000010000000000L, active1, 0x8L);
      case 119:
         return jjMoveStringLiteralDfa3_0(active0, 0x100000000000L, active1, 0L);
      case 120:
         if ((active0 & 0x4000000000L) != 0L)
            return jjStartNfaWithStates_0(2, 38, 74);
         break;
      case 121:
         if ((active0 & 0x400000000000000L) != 0L)
         {
            jjmatchedKind = 58;
            jjmatchedPos = 2;
         }
         return jjMoveStringLiteralDfa3_0(active0, 0x1a00000000000000L, active1, 0L);
      default :
         break;
   }
   return jjStartNfa_0(1, active0, active1);
}
private int jjMoveStringLiteralDfa3_0(long old0, long active0, long old1, long active1)
{
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_0(1, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(2, active0, active1);
      return 3;
   }
   switch(curChar)
   {
      case 58:
         if ((active1 & 0x2L) != 0L)
            return jjStopAtPos(3, 65);
         break;
      case 79:
         return jjMoveStringLiteralDfa4_0(active0, 0x1a00000000000000L, active1, 0L);
      case 97:
         return jjMoveStringLiteralDfa4_0(active0, 0x800000000000L, active1, 0L);
      case 99:
         return jjMoveStringLiteralDfa4_0(active0, 0x20000000000L, active1, 0L);
      case 101:
         if ((active0 & 0x2000L) != 0L)
         {
            jjmatchedKind = 13;
            jjmatchedPos = 3;
         }
         return jjMoveStringLiteralDfa4_0(active0, 0x300000004000L, active1, 0L);
      case 103:
         return jjMoveStringLiteralDfa4_0(active0, 0x400000000000L, active1, 0L);
      case 107:
         if ((active0 & 0x100000000000000L) != 0L)
            return jjStartNfaWithStates_0(3, 56, 74);
         break;
      case 109:
         if ((active0 & 0x80000000000L) != 0L)
            return jjStartNfaWithStates_0(3, 43, 74);
         return jjMoveStringLiteralDfa4_0(active0, 0L, active1, 0x8L);
      case 110:
         return jjMoveStringLiteralDfa4_0(active0, 0x10000000000L, active1, 0L);
      case 111:
         return jjMoveStringLiteralDfa4_0(active0, 0x8000000000000000L, active1, 0L);
      case 114:
         if ((active0 & 0x40000000000000L) != 0L)
            return jjStartNfaWithStates_0(3, 54, 74);
         else if ((active0 & 0x2000000000000000L) != 0L)
            return jjStartNfaWithStates_0(3, 61, 74);
         return jjMoveStringLiteralDfa4_0(active0, 0x18000000000000L, active1, 0L);
      case 115:
         return jjMoveStringLiteralDfa4_0(active0, 0x40000000000L, active1, 0L);
      case 116:
         if ((active0 & 0x2000000000000L) != 0L)
            return jjStartNfaWithStates_0(3, 49, 74);
         return jjMoveStringLiteralDfa4_0(active0, 0x80000000000000L, active1, 0L);
      case 117:
         return jjMoveStringLiteralDfa4_0(active0, 0x4000000000000000L, active1, 0L);
      case 119:
         return jjMoveStringLiteralDfa4_0(active0, 0x40000L, active1, 0L);
      default :
         break;
   }
   return jjStartNfa_0(2, active0, active1);
}
private int jjMoveStringLiteralDfa4_0(long old0, long active0, long old1, long active1)
{
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_0(2, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(3, active0, active1);
      return 4;
   }
   switch(curChar)
   {
      case 58:
         if ((active1 & 0x8L) != 0L)
            return jjStopAtPos(4, 67);
         break;
      case 73:
         return jjMoveStringLiteralDfa5_0(active0, 0x4000L, active1, 0L);
      case 97:
         return jjMoveStringLiteralDfa5_0(active0, 0x20000000000L, active1, 0L);
      case 101:
         return jjMoveStringLiteralDfa5_0(active0, 0x18000000040000L, active1, 0L);
      case 102:
         return jjMoveStringLiteralDfa5_0(active0, 0x1a00000000000000L, active1, 0L);
      case 104:
         if ((active0 & 0x80000000000000L) != 0L)
            return jjStartNfaWithStates_0(4, 55, 74);
         break;
      case 110:
         return jjMoveStringLiteralDfa5_0(active0, 0x8000000000000000L, active1, 0L);
      case 114:
         if ((active0 & 0x100000000000L) != 0L)
            return jjStartNfaWithStates_0(4, 44, 74);
         else if ((active0 & 0x200000000000L) != 0L)
            return jjStartNfaWithStates_0(4, 45, 74);
         break;
      case 116:
         if ((active0 & 0x10000000000L) != 0L)
            return jjStartNfaWithStates_0(4, 40, 74);
         return jjMoveStringLiteralDfa5_0(active0, 0x4000c40000000000L, active1, 0L);
      default :
         break;
   }
   return jjStartNfa_0(3, active0, active1);
}
private int jjMoveStringLiteralDfa5_0(long old0, long active0, long old1, long active1)
{
   if (((active0 &= old0) | (active1 &= old1)) == 0L)
      return jjStartNfa_0(3, old0, old1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(4, active0, 0L);
      return 5;
   }
   switch(curChar)
   {
      case 77:
         return jjMoveStringLiteralDfa6_0(active0, 0x800000000000000L);
      case 87:
         return jjMoveStringLiteralDfa6_0(active0, 0x1000000000000000L);
      case 89:
         return jjMoveStringLiteralDfa6_0(active0, 0x200000000000000L);
      case 100:
         if ((active0 & 0x8000000000000000L) != 0L)
            return jjStartNfaWithStates_0(5, 63, 74);
         break;
      case 101:
         if ((active0 & 0x800000000000L) != 0L)
            return jjStartNfaWithStates_0(5, 47, 74);
         else if ((active0 & 0x4000000000000000L) != 0L)
            return jjStartNfaWithStates_0(5, 62, 74);
         return jjMoveStringLiteralDfa6_0(active0, 0x40000L);
      case 103:
         return jjMoveStringLiteralDfa6_0(active0, 0x4000L);
      case 104:
         if ((active0 & 0x400000000000L) != 0L)
            return jjStartNfaWithStates_0(5, 46, 74);
         break;
      case 110:
         return jjMoveStringLiteralDfa6_0(active0, 0x18000000000000L);
      case 114:
         return jjMoveStringLiteralDfa6_0(active0, 0x40000000000L);
      case 116:
         if ((active0 & 0x20000000000L) != 0L)
            return jjStartNfaWithStates_0(5, 41, 74);
         break;
      default :
         break;
   }
   return jjStartNfa_0(4, active0, 0L);
}
private int jjMoveStringLiteralDfa6_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(4, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(5, active0, 0L);
      return 6;
   }
   switch(curChar)
   {
      case 101:
         return jjMoveStringLiteralDfa7_0(active0, 0x1200000000000000L);
      case 105:
         return jjMoveStringLiteralDfa7_0(active0, 0x40000000000L);
      case 110:
         if ((active0 & 0x40000L) != 0L)
            return jjStartNfaWithStates_0(6, 18, 74);
         return jjMoveStringLiteralDfa7_0(active0, 0x4000L);
      case 111:
         return jjMoveStringLiteralDfa7_0(active0, 0x800000000000000L);
      case 116:
         return jjMoveStringLiteralDfa7_0(active0, 0x18000000000000L);
      default :
         break;
   }
   return jjStartNfa_0(5, active0, 0L);
}
private int jjMoveStringLiteralDfa7_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(5, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(6, active0, 0L);
      return 7;
   }
   switch(curChar)
   {
      case 68:
         return jjMoveStringLiteralDfa8_0(active0, 0x8000000000000L);
      case 84:
         return jjMoveStringLiteralDfa8_0(active0, 0x10000000000000L);
      case 97:
         return jjMoveStringLiteralDfa8_0(active0, 0x200000000000000L);
      case 101:
         return jjMoveStringLiteralDfa8_0(active0, 0x1000000000000000L);
      case 110:
         return jjMoveStringLiteralDfa8_0(active0, 0x800040000000000L);
      case 111:
         return jjMoveStringLiteralDfa8_0(active0, 0x4000L);
      default :
         break;
   }
   return jjStartNfa_0(6, active0, 0L);
}
private int jjMoveStringLiteralDfa8_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(6, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(7, active0, 0L);
      return 8;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa9_0(active0, 0x8000000000000L);
      case 103:
         if ((active0 & 0x40000000000L) != 0L)
            return jjStartNfaWithStates_0(8, 42, 74);
         break;
      case 105:
         return jjMoveStringLiteralDfa9_0(active0, 0x10000000000000L);
      case 107:
         if ((active0 & 0x1000000000000000L) != 0L)
            return jjStartNfaWithStates_0(8, 60, 74);
         break;
      case 114:
         if ((active0 & 0x200000000000000L) != 0L)
            return jjStartNfaWithStates_0(8, 57, 74);
         return jjMoveStringLiteralDfa9_0(active0, 0x4000L);
      case 116:
         return jjMoveStringLiteralDfa9_0(active0, 0x800000000000000L);
      default :
         break;
   }
   return jjStartNfa_0(7, active0, 0L);
}
private int jjMoveStringLiteralDfa9_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(7, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(8, active0, 0L);
      return 9;
   }
   switch(curChar)
   {
      case 101:
         return jjMoveStringLiteralDfa10_0(active0, 0x4000L);
      case 104:
         if ((active0 & 0x800000000000000L) != 0L)
            return jjStartNfaWithStates_0(9, 59, 74);
         break;
      case 109:
         return jjMoveStringLiteralDfa10_0(active0, 0x10000000000000L);
      case 116:
         return jjMoveStringLiteralDfa10_0(active0, 0x8000000000000L);
      default :
         break;
   }
   return jjStartNfa_0(8, active0, 0L);
}
private int jjMoveStringLiteralDfa10_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(8, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(9, active0, 0L);
      return 10;
   }
   switch(curChar)
   {
      case 67:
         return jjMoveStringLiteralDfa11_0(active0, 0x4000L);
      case 101:
         if ((active0 & 0x8000000000000L) != 0L)
            return jjStartNfaWithStates_0(10, 51, 74);
         else if ((active0 & 0x10000000000000L) != 0L)
            return jjStartNfaWithStates_0(10, 52, 26);
         break;
      default :
         break;
   }
   return jjStartNfa_0(9, active0, 0L);
}
private int jjMoveStringLiteralDfa11_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(9, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(10, active0, 0L);
      return 11;
   }
   switch(curChar)
   {
      case 97:
         return jjMoveStringLiteralDfa12_0(active0, 0x4000L);
      default :
         break;
   }
   return jjStartNfa_0(10, active0, 0L);
}
private int jjMoveStringLiteralDfa12_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(10, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(11, active0, 0L);
      return 12;
   }
   switch(curChar)
   {
      case 115:
         return jjMoveStringLiteralDfa13_0(active0, 0x4000L);
      default :
         break;
   }
   return jjStartNfa_0(11, active0, 0L);
}
private int jjMoveStringLiteralDfa13_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_0(11, old0, 0L);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_0(12, active0, 0L);
      return 13;
   }
   switch(curChar)
   {
      case 101:
         if ((active0 & 0x4000L) != 0L)
            return jjStartNfaWithStates_0(13, 14, 74);
         break;
      default :
         break;
   }
   return jjStartNfa_0(12, active0, 0L);
}
private int jjStartNfaWithStates_0(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_0(state, pos + 1);
}
private int jjMoveNfa_0(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 74;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 26:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 32:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 63:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 5:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 64:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 30:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 29:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 35:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 27:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 33:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 6:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 74:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 3:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(3, 8);
                  else if (curChar == 46)
                     jjCheckNAdd(42);
                  if ((0x3fe000000000000L & l) != 0L)
                  {
                     if (kind > 81)
                        kind = 81;
                     jjCheckNAddTwoStates(39, 40);
                  }
                  else if (curChar == 48)
                  {
                     if (kind > 81)
                        kind = 81;
                     jjCheckNAddStates(9, 11);
                  }
                  break;
               case 31:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 36:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 28:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 34:
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 70)
                        kind = 70;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  if ((0x3ff000000000000L & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  else if (curChar == 43)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAdd(69);
                  }
                  break;
               case 38:
                  if ((0x3fe000000000000L & l) == 0L)
                     break;
                  if (kind > 81)
                     kind = 81;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 39:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 81)
                     kind = 81;
                  jjCheckNAddTwoStates(39, 40);
                  break;
               case 41:
                  if (curChar == 46)
                     jjCheckNAdd(42);
                  break;
               case 42:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddStates(12, 14);
                  break;
               case 44:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(45);
                  break;
               case 45:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(45, 46);
                  break;
               case 47:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(3, 8);
                  break;
               case 48:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(48, 49);
                  break;
               case 49:
                  if (curChar != 46)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddStates(15, 17);
                  break;
               case 50:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddStates(15, 17);
                  break;
               case 51:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(51, 52);
                  break;
               case 53:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(54);
                  break;
               case 54:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 82)
                     kind = 82;
                  jjCheckNAddTwoStates(54, 46);
                  break;
               case 55:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(55, 46);
                  break;
               case 56:
                  if (curChar != 48)
                     break;
                  if (kind > 81)
                     kind = 81;
                  jjCheckNAddStates(9, 11);
                  break;
               case 57:
                  if ((0xff000000000000L & l) == 0L)
                     break;
                  if (kind > 81)
                     kind = 81;
                  jjCheckNAddTwoStates(57, 40);
                  break;
               case 59:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 81)
                     kind = 81;
                  jjCheckNAddTwoStates(59, 40);
                  break;
               case 67:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 69)
                     kind = 69;
                  jjCheckNAddStates(0, 2);
                  break;
               case 68:
                  if (curChar != 43)
                     break;
                  if (kind > 69)
                     kind = 69;
                  jjCheckNAdd(69);
                  break;
               case 69:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 70;
                  break;
               case 71:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 69)
                     kind = 69;
                  jjCheckNAddStates(18, 20);
                  break;
               case 72:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAddTwoStates(72, 73);
                  break;
               case 73:
                  if (curChar == 43 && kind > 70)
                     kind = 70;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 26:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 25;
                  break;
               case 32:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 31;
                  break;
               case 63:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 64;
                  else if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 62;
                  break;
               case 5:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 64:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 119)
                  {
                     if (kind > 53)
                        kind = 53;
                  }
                  break;
               case 30:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 84)
                     jjstateSet[jjnewStateCnt++] = 29;
                  break;
               case 29:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 105)
                     jjstateSet[jjnewStateCnt++] = 28;
                  break;
               case 35:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 34;
                  break;
               case 27:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 33:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 101)
                     jjstateSet[jjnewStateCnt++] = 32;
                  break;
               case 6:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 74:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  break;
               case 3:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(21, 25);
                  }
                  if (curChar == 110)
                     jjAddStates(26, 27);
                  else if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 36;
                  else if (curChar == 70)
                     jjstateSet[jjnewStateCnt++] = 20;
                  else if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 15;
                  else if (curChar == 84)
                     jjstateSet[jjnewStateCnt++] = 10;
                  else if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 6;
                  else if (curChar == 78)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 31:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 30;
                  break;
               case 36:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 28:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 34:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 70)
                        kind = 70;
                     jjCheckNAddTwoStates(72, 73);
                  }
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                     jjCheckNAddStates(0, 2);
                  }
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 0:
                  if (curChar == 76 && kind > 33)
                     kind = 33;
                  break;
               case 1:
                  if (curChar == 76)
                     jjstateSet[jjnewStateCnt++] = 0;
                  break;
               case 2:
                  if (curChar == 85)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 4:
                  if (curChar == 101 && kind > 34)
                     kind = 34;
                  break;
               case 7:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 8:
                  if (curChar == 69 && kind > 34)
                     kind = 34;
                  break;
               case 9:
                  if (curChar == 85)
                     jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 10:
                  if (curChar == 82)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if (curChar == 84)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if (curChar == 101 && kind > 35)
                     kind = 35;
                  break;
               case 13:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 16:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 15;
                  break;
               case 17:
                  if (curChar == 69 && kind > 35)
                     kind = 35;
                  break;
               case 18:
                  if (curChar == 83)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 19:
                  if (curChar == 76)
                     jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 20:
                  if (curChar == 65)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 21:
                  if (curChar == 70)
                     jjstateSet[jjnewStateCnt++] = 20;
                  break;
               case 22:
                  if (curChar == 112 && kind > 53)
                     kind = 53;
                  break;
               case 23:
                  if (curChar == 109)
                     jjstateSet[jjnewStateCnt++] = 22;
                  break;
               case 24:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 23;
                  break;
               case 25:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 37:
                  if (curChar == 99)
                     jjstateSet[jjnewStateCnt++] = 36;
                  break;
               case 40:
                  if ((0x110000001100L & l) != 0L && kind > 81)
                     kind = 81;
                  break;
               case 43:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(28, 29);
                  break;
               case 46:
                  if ((0x5400000054L & l) != 0L && kind > 82)
                     kind = 82;
                  break;
               case 52:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(30, 31);
                  break;
               case 58:
                  if ((0x100000001000000L & l) != 0L)
                     jjCheckNAdd(59);
                  break;
               case 59:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 81)
                     kind = 81;
                  jjCheckNAddTwoStates(59, 40);
                  break;
               case 60:
                  if (curChar == 110)
                     jjAddStates(26, 27);
                  break;
               case 61:
                  if (curChar == 108 && kind > 33)
                     kind = 33;
                  break;
               case 62:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 65:
                  if (curChar == 111)
                     jjstateSet[jjnewStateCnt++] = 64;
                  break;
               case 66:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 69)
                     kind = 69;
                  jjCheckNAddStates(21, 25);
                  break;
               case 67:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 69)
                     kind = 69;
                  jjCheckNAddStates(0, 2);
                  break;
               case 70:
               case 71:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 69)
                     kind = 69;
                  jjCheckNAddStates(18, 20);
                  break;
               case 72:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 70)
                     kind = 70;
                  jjCheckNAddTwoStates(72, 73);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 74 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1)
{
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_1(int pos, long active0, long active1)
{
   return jjMoveNfa_1(jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_1()
{
   switch(curChar)
   {
      case 39:
         return jjStopAtPos(0, 77);
      default :
         return jjMoveNfa_1(0, 0);
   }
}
static final long[] jjbitVec0 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec2 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private int jjMoveNfa_1(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 6;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffff7fffffffffL & l) != 0L && kind > 76)
                     kind = 76;
                  break;
               case 1:
                  if ((0x8400000000L & l) != 0L && kind > 75)
                     kind = 75;
                  break;
               case 2:
                  if ((0xf000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 3:
                  if ((0xff000000000000L & l) == 0L)
                     break;
                  if (kind > 75)
                     kind = 75;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 4:
                  if ((0xff000000000000L & l) != 0L && kind > 75)
                     kind = 75;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffffffefffffffL & l) != 0L)
                  {
                     if (kind > 76)
                        kind = 76;
                  }
                  else if (curChar == 92)
                     jjAddStates(32, 34);
                  break;
               case 1:
                  if ((0x14404510000000L & l) != 0L && kind > 75)
                     kind = 75;
                  break;
               case 5:
                  if ((0xffffffffefffffffL & l) != 0L && kind > 76)
                     kind = 76;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 76)
                     kind = 76;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 6 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1)
{
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_2(int pos, long active0, long active1)
{
   return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_2()
{
   switch(curChar)
   {
      case 34:
         return jjStopAtPos(0, 80);
      default :
         return jjMoveNfa_2(0, 0);
   }
}
private int jjMoveNfa_2(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 6;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xfffffffbffffffffL & l) != 0L && kind > 79)
                     kind = 79;
                  break;
               case 1:
                  if ((0x8400000000L & l) != 0L && kind > 78)
                     kind = 78;
                  break;
               case 2:
                  if ((0xf000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 3:
                  if ((0xff000000000000L & l) == 0L)
                     break;
                  if (kind > 78)
                     kind = 78;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 4:
                  if ((0xff000000000000L & l) != 0L && kind > 78)
                     kind = 78;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffffffefffffffL & l) != 0L)
                  {
                     if (kind > 79)
                        kind = 79;
                  }
                  else if (curChar == 92)
                     jjAddStates(32, 34);
                  break;
               case 1:
                  if ((0x14404510000000L & l) != 0L && kind > 78)
                     kind = 78;
                  break;
               case 5:
                  if ((0xffffffffefffffffL & l) != 0L && kind > 79)
                     kind = 79;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 79)
                     kind = 79;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 6 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
static final int[] jjnextStates = {
   67, 68, 69, 48, 49, 51, 52, 55, 46, 57, 58, 40, 42, 43, 46, 50, 
   43, 46, 69, 71, 68, 67, 68, 69, 72, 73, 63, 65, 44, 45, 53, 54, 
   1, 2, 3, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec2[i2] & l2) != 0L);
      default :
         if ((jjbitVec0[i1] & l1) != 0L)
            return true;
         return false;
   }
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
"", "\157\162", "\141\156\144", "\156\157\164", "\41", "\75", "\75\75", 
"\41\75", "\74\76", "\74\75", "\74", "\76", "\76\75", "\154\151\153\145", 
"\154\151\153\145\111\147\156\157\162\145\103\141\163\145", "\151\156", "\50", "\51", "\142\145\164\167\145\145\156", "\54", "\174", 
"\136", "\46", "\74\74", "\76\76", "\53", "\55", "\57", "\176", null, null, null, null, 
null, null, null, "\141\166\147", "\155\151\156", "\155\141\170", "\163\165\155", 
"\143\157\165\156\164", "\143\157\156\143\141\164", "\163\165\142\163\164\162\151\156\147", 
"\164\162\151\155", "\154\157\167\145\162", "\165\160\160\145\162", "\154\145\156\147\164\150", 
"\154\157\143\141\164\145", "\141\142\163", "\163\161\162\164", "\155\157\144", 
"\143\165\162\162\145\156\164\104\141\164\145", "\143\165\162\162\145\156\164\124\151\155\145", null, "\171\145\141\162", 
"\155\157\156\164\150", "\167\145\145\153", "\144\141\171\117\146\131\145\141\162", "\144\141\171", 
"\144\141\171\117\146\115\157\156\164\150", "\144\141\171\117\146\127\145\145\153", "\150\157\165\162", 
"\155\151\156\165\164\145", "\163\145\143\157\156\144", "\44", "\157\142\152\72", "\144\142\72", 
"\145\156\165\155\72", "\52", null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, };

/** Lexer state names. */
public static final String[] lexStateNames = {
   "DEFAULT",
   "WithinSingleQuoteLiteral",
   "WithinDoubleQuoteLiteral",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 2, 
   -1, -1, 0, -1, -1, 0, -1, -1, -1, -1, -1, -1, 
};
static final long[] jjtoToken = {
   0xfffffffe1fffffffL, 0x7207fL, 
};
static final long[] jjtoSkip = {
   0x1e0000000L, 0x0L, 
};
static final long[] jjtoMore = {
   0x0L, 0xde00L, 
};
protected JavaCharStream input_stream;
private final int[] jjrounds = new int[74];
private final int[] jjstateSet = new int[148];
private final StringBuilder jjimage = new StringBuilder();
private StringBuilder image = jjimage;
private int jjimageLen;
private int lengthOfMatch;
protected char curChar;
/** Constructor. */
public ExpressionParserTokenManager(JavaCharStream stream){
   if (JavaCharStream.staticFlag)
      throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
   input_stream = stream;
}

/** Constructor. */
public ExpressionParserTokenManager(JavaCharStream stream, int lexState){
   this(stream);
   SwitchTo(lexState);
}

/** Reinitialise parser. */
public void ReInit(JavaCharStream stream)
{
   jjmatchedPos = jjnewStateCnt = 0;
   curLexState = defaultLexState;
   input_stream = stream;
   ReInitRounds();
}
private void ReInitRounds()
{
   int i;
   jjround = 0x80000001;
   for (i = 74; i-- > 0;)
      jjrounds[i] = 0x80000000;
}

/** Reinitialise parser. */
public void ReInit(JavaCharStream stream, int lexState)
{
   ReInit(stream);
   SwitchTo(lexState);
}

/** Switch to specified lex state. */
public void SwitchTo(int lexState)
{
   if (lexState >= 3 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
   else
      curLexState = lexState;
}

protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   String im = jjstrLiteralImages[jjmatchedKind];
   curTokenImage = (im == null) ? input_stream.GetImage() : im;
   beginLine = input_stream.getBeginLine();
   beginColumn = input_stream.getBeginColumn();
   endLine = input_stream.getEndLine();
   endColumn = input_stream.getEndColumn();
   t = Token.newToken(jjmatchedKind, curTokenImage);

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {
   try
   {
      curChar = input_stream.BeginToken();
   }
   catch(java.io.IOException e)
   {
      jjmatchedKind = 0;
      matchedToken = jjFillToken();
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   for (;;)
   {
     switch(curLexState)
     {
       case 0:
         try { input_stream.backup(0);
            while (curChar <= 32 && (0x100002600L & (1L << curChar)) != 0L)
               curChar = input_stream.BeginToken();
         }
         catch (java.io.IOException e1) { continue EOFLoop; }
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_0();
         break;
       case 1:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_1();
         break;
       case 2:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_2();
         break;
     }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
           TokenLexicalActions(matchedToken);
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           return matchedToken;
        }
        else if ((jjtoSkip[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
        MoreLexicalActions();
      if (jjnewLexState[jjmatchedKind] != -1)
        curLexState = jjnewLexState[jjmatchedKind];
        curPos = 0;
        jjmatchedKind = 0x7fffffff;
        try {
           curChar = input_stream.readChar();
           continue;
        }
        catch (java.io.IOException e1) { }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
   }
  }
}

void MoreLexicalActions()
{
   jjimageLen += (lengthOfMatch = jjmatchedPos + 1);
   switch(jjmatchedKind)
   {
      case 73 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
           stringBuffer = new StringBuffer();
         break;
      case 74 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
            stringBuffer = new StringBuffer();
         break;
      case 75 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
          stringBuffer.append( escapeChar() );
         break;
      case 76 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
          stringBuffer.append( image.charAt(image.length()-1) );
         break;
      case 78 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
          stringBuffer.append( escapeChar() );
         break;
      case 79 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
          stringBuffer.append( image.charAt(image.length()-1) );
         break;
      default :
         break;
   }
}
void TokenLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 77 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          literalValue = stringBuffer.toString();
         break;
      case 80 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          literalValue = stringBuffer.toString();
         break;
      case 81 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          literalValue = makeInt();
         break;
      case 82 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          literalValue = makeFloat();
         break;
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

private void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}

}
