/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.IntegerConverter;

public class FloatConverter
implements BytesConverter<Float> {
    public static final BytesConverter<Float> INSTANCE = new FloatConverter();
    private static final int BYTES = 4;

    static float getFloat(byte[] bytes) {
        if (bytes.length > 4) {
            throw new IllegalArgumentException("byte[] is too large for a single float value: " + bytes.length);
        }
        return Float.intBitsToFloat(IntegerConverter.getInt(bytes));
    }

    static byte[] getBytes(float f) {
        return IntegerConverter.getBytes(Float.floatToRawIntBits(f));
    }

    @Override
    public Float fromBytes(byte[] bytes) {
        return Float.valueOf(FloatConverter.getFloat(bytes));
    }

    @Override
    public byte[] toBytes(Float value) {
        return FloatConverter.getBytes(value.floatValue());
    }
}

