/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.commitlog;

import org.apache.cayenne.ObjectId;
import org.apache.cayenne.commitlog.Confidential;
import org.apache.cayenne.commitlog.meta.CommitLogEntity;
import org.apache.cayenne.commitlog.meta.CommitLogEntityFactory;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.GraphChangeHandler;

class DiffFilter
implements GraphChangeHandler {
    private CommitLogEntityFactory entityFactory;
    private GraphChangeHandler delegate;

    DiffFilter(CommitLogEntityFactory entityFactory, GraphChangeHandler delegate) {
        this.entityFactory = entityFactory;
        this.delegate = delegate;
    }

    public void nodeIdChanged(Object nodeId, Object newId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded()) {
            this.delegate.nodeIdChanged(nodeId, newId);
        }
    }

    public void nodeCreated(Object nodeId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded()) {
            this.delegate.nodeCreated(nodeId);
        }
    }

    public void nodeRemoved(Object nodeId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded()) {
            this.delegate.nodeRemoved(nodeId);
        }
    }

    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
        CommitLogEntity entity = this.entityFactory.getEntity((ObjectId)nodeId);
        if (entity.isIncluded(property)) {
            if (entity.isConfidential(property)) {
                oldValue = Confidential.getInstance();
                newValue = Confidential.getInstance();
            }
            this.delegate.nodePropertyChanged(nodeId, property, oldValue, newValue);
        }
    }

    public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded(arcId.toString())) {
            this.delegate.arcCreated(nodeId, targetNodeId, arcId);
        }
    }

    public void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
        if (this.entityFactory.getEntity((ObjectId)nodeId).isIncluded(arcId.toString())) {
            this.delegate.arcDeleted(nodeId, targetNodeId, arcId);
        }
    }
}

