/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

final class DataDomainIndirectDiffBuilder
implements GraphChangeHandler {
    private final EntityResolver resolver;
    private Collection<ObjectId> indirectModifications;

    DataDomainIndirectDiffBuilder(EntityResolver resolver) {
        this.resolver = resolver;
    }

    void processChanges(ObjectStoreGraphDiff allChanges) {
        allChanges.getChangesByObjectId().forEach((obj, diff) -> diff.apply(this));
    }

    Collection<ObjectId> getIndirectModifications() {
        return this.indirectModifications;
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.processArcChange((ObjectId)nodeId, arcId);
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.processArcChange((ObjectId)nodeId, arcId);
    }

    private void processArcChange(ObjectId nodeId, ArcId arcId) {
        ObjEntity entity = this.resolver.getObjEntity(nodeId.getEntityName());
        ObjRelationship relationship = entity.getRelationship(arcId.getForwardArc());
        if (relationship != null && relationship.isSourceIndependentFromTargetChange()) {
            if (!nodeId.isTemporary()) {
                if (this.indirectModifications == null) {
                    this.indirectModifications = new HashSet<ObjectId>();
                }
                this.indirectModifications.add(nodeId);
            }
            if (relationship.isFlattened() && relationship.isReadOnly()) {
                throw new CayenneRuntimeException("Cannot change the read-only flattened relationship %s in ObjEntity '%s'.", relationship.getName(), relationship.getSourceEntity().getName());
            }
        }
    }
}

