/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.Objects;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.map.DbEntity;

public abstract class BaseDbRowOp
implements DbRowOp {
    protected final Persistent object;
    protected final DbEntity entity;
    protected ObjectId changeId;
    protected int hashCode;

    protected BaseDbRowOp(Persistent object, DbEntity entity, ObjectId id) {
        this.object = Objects.requireNonNull(object);
        this.entity = Objects.requireNonNull(entity);
        this.changeId = Objects.requireNonNull(id);
        this.hashCode = this.changeId.hashCode();
    }

    @Override
    public DbEntity getEntity() {
        return this.entity;
    }

    @Override
    public ObjectId getChangeId() {
        return this.changeId;
    }

    @Override
    public Persistent getObject() {
        return this.object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbRowOp)) {
            return false;
        }
        DbRowOp other = (DbRowOp)o;
        return this.changeId.equals(other.getChangeId());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.entity.getName() + " " + this.changeId;
    }

    protected boolean entitiesHaveSameNameAndDataMap(DbRowOp rowOp) {
        return this.getEntity().getName().equals(rowOp.getEntity().getName()) && this.getEntity().getDataMap().getName().equals(rowOp.getEntity().getDataMap().getName());
    }
}

