/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.cgen;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.modeler.util.CayenneDialog;

public class TemplateDialogView
extends CayenneDialog {
    private JTable pathTable;
    private JButton useDefault;
    private JButton addTemplate;
    private List<String> missingPathes;

    public TemplateDialogView(Dialog parent, String templatePath, String superTemplatePath) {
        super(parent);
        this.initPathes(templatePath, superTemplatePath);
        this.init();
    }

    public TemplateDialogView(Frame parent, String templatePath, String superTemplatePath) {
        super(parent);
        this.initPathes(templatePath, superTemplatePath);
        this.init();
    }

    private void initPathes(String templatePath, String superTemplatePath) {
        this.missingPathes = new ArrayList<String>();
        if (templatePath != null) {
            this.missingPathes.add(templatePath);
        }
        if (superTemplatePath != null) {
            this.missingPathes.add(superTemplatePath);
        }
    }

    private void init() {
        this.useDefault = new JButton("Use default");
        this.addTemplate = new JButton("Add template");
        this.pathTable = new JTable();
        this.pathTable.setRowHeight(25);
        this.pathTable.setRowMargin(3);
        this.pathTable.setCellSelectionEnabled(false);
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("fill:200dlu:grow", "pref, 3dlu, fill:40dlu:grow"));
        builder.setDefaultDialogBorder();
        builder.addLabel("This templates are missing: ", cc.xy(1, 1));
        builder.add((Component)new JScrollPane(this.pathTable), cc.xy(1, 3));
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.useDefault);
        buttons.add(this.addTemplate);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.pathTable.setModel(new MissingPathTableModel());
        this.setPreferredSize(new Dimension(450, 350));
    }

    public JButton getUseDefault() {
        return this.useDefault;
    }

    public JButton getAddTemplate() {
        return this.addTemplate;
    }

    class MissingPathTableModel
    extends AbstractTableModel {
        MissingPathTableModel() {
        }

        @Override
        public int getRowCount() {
            return TemplateDialogView.this.missingPathes.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return TemplateDialogView.this.missingPathes.get(row);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int column) {
            return " ";
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }
    }
}

