/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph.extension;

import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.modeler.graph.GraphMap;
import org.apache.cayenne.modeler.graph.GraphRegistry;
import org.apache.cayenne.project.extension.BaseSaverDelegate;

class GraphSaverDelegate
extends BaseSaverDelegate {
    DataChannelMetaData metaData;

    GraphSaverDelegate(DataChannelMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public Void visitDataChannelDescriptor(DataChannelDescriptor channelDescriptor) {
        GraphRegistry registry = this.metaData.get(channelDescriptor, GraphRegistry.class);
        if (registry == null) {
            return null;
        }
        if (this.isStandalone()) {
            this.printGraphs(channelDescriptor);
        } else {
            this.printInclude(channelDescriptor);
        }
        return null;
    }

    private void printGraphs(DataChannelDescriptor channelDescriptor) {
        GraphRegistry registry = this.metaData.get(channelDescriptor, GraphRegistry.class);
        GraphMap map = registry.getGraphMap(channelDescriptor);
        this.encoder.start("graphs").attribute("xmlns", "http://cayenne.apache.org/schema/10/graph").nested(map, (ConfigurationNodeVisitor)this.getParentDelegate()).end();
    }

    private void printInclude(DataChannelDescriptor channelDescriptor) {
        this.encoder.start("xi:include").attribute("xmlns:xi", "http://www.w3.org/2001/XInclude").attribute("href", channelDescriptor.getName() + ".graph.xml").end();
    }
}

