/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph;

import java.util.Map;
import org.objectstyle.ashwood.graph.ArcIterator;
import org.objectstyle.ashwood.graph.DepthFirstSearch;
import org.objectstyle.ashwood.graph.DigraphIteration;

public class DepthFirstStampSearch
extends DepthFirstSearch {
    public static final int UNDEFINED_STAMP = -1;
    public static final int GROW_DEPTH_STAMP = 0;
    public static final int GROW_BREADTH_STAMP = 1;
    public static final int SHRINK_STAMP = 2;
    public static final int LEAF_STAMP = 3;
    private int stamp = -1;

    public DepthFirstStampSearch(DigraphIteration factory, Object firstVertex) {
        super(factory, firstVertex);
    }

    public int getStamp() {
        return this.stamp;
    }

    public Object next() {
        ArcIterator i = (ArcIterator)this.stack.peek();
        Object origin = i.getOrigin();
        Object dst = i.getDestination();
        if (dst == null) {
            if (i.hasNext()) {
                i.next();
                dst = i.getDestination();
            } else {
                this.stack.pop();
                this.stamp = 3;
                return origin;
            }
        }
        if (this.seen.add(dst)) {
            this.stack.push(this.factory.outgoingIterator(dst));
            this.stamp = 0;
            if (i.hasNext()) {
                i.next();
            }
        } else if (i.hasNext()) {
            i.next();
            this.stamp = 1;
        } else {
            this.stack.pop();
            this.stamp = 2;
        }
        return origin;
    }

    public Map traverse(Map orders) {
        int preOrder = 0;
        int postOrder = 0;
        while (this.hasNext()) {
            Object vertex = this.next();
            int stamp = this.getStamp();
            if (stamp == 2) {
                ++postOrder;
                OrderPair pair = (OrderPair)orders.get(vertex);
                if (pair == null) {
                    orders.put(vertex, new OrderPair(++preOrder, postOrder));
                    continue;
                }
                pair.postOrder = postOrder;
                continue;
            }
            if (stamp == 3) {
                orders.put(vertex, new OrderPair(++preOrder, ++postOrder));
                continue;
            }
            if (orders.containsKey(vertex)) continue;
            orders.put(vertex, new OrderPair(++preOrder, -1));
        }
        return orders;
    }

    public static class OrderPair {
        private int preOrder;
        private int postOrder;

        public OrderPair(int preOrder, int postOrder) {
            this.preOrder = preOrder;
            this.postOrder = postOrder;
        }

        public int getPreOrder() {
            return this.preOrder;
        }

        public int getPostOrder() {
            return this.postOrder;
        }

        public String toString() {
            return "(" + this.preOrder + ", " + this.postOrder + ")";
        }
    }
}

