/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.enhancer;

import java.util.Collection;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.enhancer.DoubleEnhanceException;
import org.apache.cayenne.enhancer.EnhancementHelper;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PojoVisitor
extends ClassAdapter {
    static String ENHANCED_INTERFACE_SIG = Type.getInternalName(Persistent.class);
    protected EnhancementHelper helper = new EnhancementHelper((ClassVisitor)this);

    public PojoVisitor(ClassVisitor visitor) {
        super(visitor);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        for (String anInterface : interfaces) {
            if (!ENHANCED_INTERFACE_SIG.equals(anInterface)) continue;
            throw new DoubleEnhanceException(name + " already implements " + ENHANCED_INTERFACE_SIG);
        }
        this.helper.reset(name);
        interfaces = this.helper.addInterface(interfaces, Persistent.class);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitEnd() {
        this.helper.createProperty(ObjectId.class, "objectId");
        this.helper.createProperty(ObjectContext.class, "objectContext", true);
        this.helper.createProperty(Integer.TYPE, "persistenceState");
        for (String property : this.getLazilyFaultedProperties()) {
            this.helper.createField(Boolean.TYPE, "faultResolved_" + property, true);
        }
    }

    protected abstract Collection<String> getLazilyFaultedProperties();
}

