/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverterTestBase;
import org.apache.commons.beanutils.converters.DateTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;

public class SqlTimeConverterTestCase
extends DateConverterTestBase {
    public static TestSuite suite() {
        return new TestSuite(SqlTimeConverterTestCase.class);
    }

    public SqlTimeConverterTestCase(String name) {
        super(name);
    }

    @Override
    protected Class<?> getExpectedType() {
        return Time.class;
    }

    private boolean isUSTimeFormatWithNarrowNoBreakSpace() {
        DateFormat usDateFormat = DateFormat.getTimeInstance(3, Locale.US);
        return ((SimpleDateFormat)usDateFormat).toPattern().contains("\u202f");
    }

    @Override
    protected DateTimeConverter makeConverter() {
        return new SqlTimeConverter();
    }

    @Override
    protected DateTimeConverter makeConverter(Object defaultValue) {
        return new SqlTimeConverter(defaultValue);
    }

    @Override
    public void testDefaultStringToTypeConvert() {
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(false);
        String testString = "15:36:21";
        Object expected = this.toType("15:36:21", "HH:mm:ss", null);
        this.validConversion((Converter)converter, expected, "15:36:21");
        this.invalidConversion((Converter)converter, "15:36");
    }

    @Override
    public void testLocale() {
        String testString;
        String pattern;
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        if (this.isUSTimeFormatWithNarrowNoBreakSpace()) {
            pattern = "h:mm\u202fa";
            testString = "3:06\u202fpm";
        } else {
            pattern = "h:mm a";
            testString = "3:06 pm";
        }
        DateTimeConverter converter = this.makeConverter();
        converter.setUseLocaleFormat(true);
        Object expected = this.toType(testString, pattern, null);
        this.validConversion((Converter)converter, expected, testString);
        this.invalidConversion((Converter)converter, null);
        this.invalidConversion((Converter)converter, "");
        this.invalidConversion((Converter)converter, "13:05");
        this.invalidConversion((Converter)converter, "11:05 p");
        this.invalidConversion((Converter)converter, "11.05 pm");
        this.invalidConversion((Converter)converter, "11:05\u202fp");
        this.invalidConversion((Converter)converter, "11.05\\u202Fpm");
        this.invalidConversion((Converter)converter, 2);
        converter.setLocale(Locale.UK);
        this.invalidConversion((Converter)converter, testString);
        this.validConversion((Converter)converter, expected, "15:06");
        Locale.setDefault(defaultLocale);
    }

    @Override
    protected Object toType(Calendar value) {
        return new Time(this.getTimeInMillis(value));
    }
}

