/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public final class ArTest
extends AbstractTest {
    @Test
    void testArArchiveCreation() throws Exception {
        File output = this.newTempFile("bla.ar");
        File file1 = ArTest.getFile("test1.xml");
        File file2 = ArTest.getFile("test2.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArArchiveOutputStream os = (ArArchiveOutputStream)ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("ar", out);){
            os.putArchiveEntry(new ArArchiveEntry("test1.xml", file1.length()));
            os.write(file1);
            os.closeArchiveEntry();
            os.putArchiveEntry(new ArArchiveEntry("test2.xml", file2.length()));
            os.write(file2);
            os.closeArchiveEntry();
        }
    }

    @Test
    void testArDelete() throws Exception {
        File output = this.newTempFile("bla.ar");
        File file1 = ArTest.getFile("test1.xml");
        File file2 = ArTest.getFile("test2.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("ar", out);){
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
            os.write(file1);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
            os.write(file2);
            os.closeArchiveEntry();
        }
        Assertions.assertEquals((long)(68L + file1.length() + file1.length() % 2L + 60L + file2.length() + file2.length() % 2L), (long)output.length());
        File output2 = this.newTempFile("bla2.ar");
        int copied = 0;
        int deleted = 0;
        try (OutputStream os = Files.newOutputStream(output2.toPath(), new OpenOption[0]);
             InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream aos = new ArchiveStreamFactory().createArchiveOutputStream("ar", os);
             ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));){
            ArArchiveEntry entry;
            while ((entry = (ArArchiveEntry)ais.getNextEntry()) != null) {
                if ("test1.xml".equals(entry.getName())) {
                    aos.putArchiveEntry((ArchiveEntry)entry);
                    IOUtils.copy((InputStream)ais, (OutputStream)aos);
                    aos.closeArchiveEntry();
                    ++copied;
                    continue;
                }
                IOUtils.copy((InputStream)ais, (OutputStream)new ByteArrayOutputStream());
                ++deleted;
            }
        }
        Assertions.assertEquals((int)1, (int)copied);
        Assertions.assertEquals((int)1, (int)deleted);
        Assertions.assertEquals((long)(68L + file1.length() + file1.length() % 2L), (long)output2.length());
        long files = 0L;
        long sum = 0L;
        try (InputStream is = Files.newInputStream(output2.toPath(), new OpenOption[0]);
             ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));){
            ArArchiveEntry entry;
            while ((entry = (ArArchiveEntry)ais.getNextEntry()) != null) {
                IOUtils.copy((InputStream)ais, (OutputStream)new ByteArrayOutputStream());
                sum += entry.getLength();
                ++files;
            }
        }
        Assertions.assertEquals((long)1L, (long)files);
        Assertions.assertEquals((long)file1.length(), (long)sum);
    }

    @Test
    void testArUnarchive() throws Exception {
        File output = this.newTempFile("bla.ar");
        File file1 = ArTest.getFile("test1.xml");
        File file2 = ArTest.getFile("test2.xml");
        try (OutputStream out = Files.newOutputStream(output.toPath(), new OpenOption[0]);
             ArchiveOutputStream os = ArchiveStreamFactory.DEFAULT.createArchiveOutputStream("ar", out);){
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test1.xml", file1.length()));
            os.write(file1);
            os.closeArchiveEntry();
            os.putArchiveEntry((ArchiveEntry)new ArArchiveEntry("test2.xml", file2.length()));
            os.write(file2);
            os.closeArchiveEntry();
        }
        try (InputStream is = Files.newInputStream(output.toPath(), new OpenOption[0]);
             ArchiveInputStream in = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(is));){
            ArArchiveEntry entry = (ArArchiveEntry)in.getNextEntry();
            File target = this.newTempFile(entry.getName());
            Files.copy((InputStream)in, target.toPath(), new CopyOption[0]);
        }
    }

    @Test
    void testExplicitFileEntry() throws Exception {
        ArArchiveEntry out;
        File file = this.createTempFile();
        File archive = this.createTempFile("test.", ".ar");
        try (ArArchiveOutputStream aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            ArArchiveEntry in = new ArArchiveEntry("foo", file.length(), 0, 0, 0, file.lastModified() / 1000L);
            aos.putArchiveEntry(in);
            aos.write(file);
            aos.closeArchiveEntry();
        }
        try (ArArchiveInputStream ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = ais.getNextArEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo", (Object)out.getName());
        Assertions.assertEquals((long)file.length(), (long)out.getSize());
        Assertions.assertEquals((long)(file.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertFalse((boolean)out.isDirectory());
    }

    @Test
    void testFileEntryFromFile() throws Exception {
        ArArchiveEntry out;
        File file = this.createTempFile();
        File archive = this.createTempFile("test.", ".ar");
        try (ArArchiveOutputStream aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            ArArchiveEntry in = new ArArchiveEntry(file, "foo");
            aos.putArchiveEntry(in);
            aos.write(file);
            aos.closeArchiveEntry();
        }
        try (ArArchiveInputStream ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = ais.getNextArEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo", (Object)out.getName());
        Assertions.assertEquals((long)file.length(), (long)out.getSize());
        Assertions.assertEquals((long)(file.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertFalse((boolean)out.isDirectory());
    }

    @Test
    void testFileEntryFromPath() throws Exception {
        ArArchiveEntry out;
        File file = this.createTempFile();
        File archive = this.createTempFile("test.", ".ar");
        try (ArArchiveOutputStream aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            ArArchiveEntry in = new ArArchiveEntry(file.toPath(), "foo", new LinkOption[0]);
            aos.putArchiveEntry(in);
            aos.write(file);
            aos.closeArchiveEntry();
        }
        try (ArArchiveInputStream ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = ais.getNextArEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo", (Object)out.getName());
        Assertions.assertEquals((long)file.length(), (long)out.getSize());
        Assertions.assertEquals((long)(file.lastModified() / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertFalse((boolean)out.isDirectory());
    }

    @Disabled
    @Test
    void testXtestDirectoryEntryFromFile() throws Exception {
        ArArchiveEntry out;
        long beforeArchiveWrite;
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".ar");
        try (ArArchiveOutputStream aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            beforeArchiveWrite = tmp.lastModified();
            ArArchiveEntry in = new ArArchiveEntry(tmp, "foo");
            aos.putArchiveEntry(in);
            aos.closeArchiveEntry();
        }
        try (ArArchiveInputStream ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = ais.getNextArEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo/", (Object)out.getName());
        Assertions.assertEquals((long)0L, (long)out.getSize());
        Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertTrue((boolean)out.isDirectory());
    }

    @Disabled
    @Test
    void testXtestExplicitDirectoryEntry() throws Exception {
        ArArchiveEntry out;
        long beforeArchiveWrite;
        File tmp = this.createTempFile();
        File archive = this.createTempFile("test.", ".ar");
        try (ArArchiveOutputStream aos = new ArArchiveOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            beforeArchiveWrite = this.getTempDirFile().lastModified();
            ArArchiveEntry in = new ArArchiveEntry("foo", 0L, 0, 0, 0, tmp.lastModified() / 1000L);
            aos.putArchiveEntry(in);
            aos.closeArchiveEntry();
        }
        try (ArArchiveInputStream ais = new ArArchiveInputStream(Files.newInputStream(archive.toPath(), new OpenOption[0]));){
            out = ais.getNextArEntry();
        }
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"foo/", (Object)out.getName());
        Assertions.assertEquals((long)0L, (long)out.getSize());
        Assertions.assertEquals((long)(beforeArchiveWrite / 1000L), (long)(out.getLastModifiedDate().getTime() / 1000L));
        Assertions.assertTrue((boolean)out.isDirectory());
    }
}

