/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Random;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BigFilesIT
extends AbstractTest {
    private void readFileBiggerThan8GByte(String name) throws Exception {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(BigFilesIT.getPath(name), new OpenOption[0]));
             GzipCompressorInputStream gzin = new GzipCompressorInputStream((InputStream)in);
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)gzin);){
            int readNow;
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((long)0x200800000L, (long)e.getSize());
            long read = 0L;
            Random r = new Random(System.currentTimeMillis());
            byte[] buf = new byte[0x100000];
            while ((readNow = tin.read(buf, 0, buf.length)) > 0) {
                for (int i = 0; i < 100; ++i) {
                    int idx = r.nextInt(readNow);
                    Assertions.assertEquals((int)0, (int)buf[idx], (String)("testing byte " + (read + (long)idx)));
                }
                read += (long)readNow;
            }
            Assertions.assertEquals((long)0x200800000L, (long)read);
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    void testReadFileBiggerThan8GBytePosix() throws Exception {
        this.readFileBiggerThan8GByte("8.posix.tar.gz");
    }

    @Test
    void testReadFileBiggerThan8GByteStar() throws Exception {
        this.readFileBiggerThan8GByte("8.star.tar.gz");
    }

    @Test
    void testReadFileHeadersOfArchiveBiggerThan8GByte() throws Exception {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(BigFilesIT.getPath("8.posix.tar.gz"), new OpenOption[0]));
             GzipCompressorInputStream gzin = new GzipCompressorInputStream((InputStream)in);
             TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)gzin);){
            TarArchiveEntry e = tin.getNextTarEntry();
            Assertions.assertNotNull((Object)e);
            Assertions.assertNull((Object)tin.getNextTarEntry());
        }
    }

    @Test
    void testTarFileReadFileHeadersOfArchiveBiggerThan8GByte() throws Exception {
        Path file = BigFilesIT.getPath("8.posix.tar.gz");
        Path output = this.tempResultDir.toPath().resolve("8.posix.tar");
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
             GzipCompressorInputStream gzin = new GzipCompressorInputStream((InputStream)in);){
            Files.copy((InputStream)gzin, output, StandardCopyOption.REPLACE_EXISTING);
        }
        try (TarFile tarFile = new TarFile(output);){
            List entries = tarFile.getEntries();
            Assertions.assertEquals((int)1, (int)entries.size());
            Assertions.assertNotNull(entries.get(0));
        }
    }
}

