/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ScatterSampleTest;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.parallel.InputStreamSupplier;

public class ScatterSample {
    final ParallelScatterZipCreator scatterZipCreator = new ParallelScatterZipCreator();
    final ScatterZipOutputStream dirs;

    ScatterSample(ScatterSampleTest scatterSampleTest) throws IOException {
        this.dirs = ScatterZipOutputStream.fileBased((File)scatterSampleTest.createTempFile("scatter-dirs", "tmp"));
    }

    public void addEntry(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier streamSupplier) throws IOException {
        if (zipArchiveEntry.isDirectory() && !zipArchiveEntry.isUnixSymlink()) {
            this.dirs.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zipArchiveEntry, (InputStreamSupplier)streamSupplier));
        } else {
            this.scatterZipCreator.addArchiveEntry(zipArchiveEntry, streamSupplier);
        }
    }

    public void writeTo(ZipArchiveOutputStream zipArchiveOutputStream) throws IOException, ExecutionException, InterruptedException {
        this.dirs.writeTo(zipArchiveOutputStream);
        this.dirs.close();
        this.scatterZipCreator.writeTo(zipArchiveOutputStream);
    }
}

