/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.math.BigInteger;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class Zip64ExtendedInformationExtraFieldTest {
    private static final ZipEightByteInteger SIZE = new ZipEightByteInteger(305419896L);
    private static final ZipEightByteInteger CSIZE = new ZipEightByteInteger(162254319L);
    private static final ZipEightByteInteger OFF = new ZipEightByteInteger(BigInteger.valueOf(773738360809407847L).shiftLeft(4).setBit(3));
    private static final ZipLong DISK = new ZipLong(18);

    Zip64ExtendedInformationExtraFieldTest() {
    }

    private static void checkDisk(byte[] b, int off) {
        Assertions.assertEquals((int)18, (int)b[0 + off]);
        Assertions.assertEquals((int)0, (int)b[1 + off]);
        Assertions.assertEquals((int)0, (int)b[2 + off]);
        Assertions.assertEquals((int)0, (int)b[3 + off]);
    }

    private static void checkOffset(byte[] b, int off) {
        Assertions.assertEquals((int)120, (int)b[0 + off]);
        Assertions.assertEquals((int)86, (int)b[1 + off]);
        Assertions.assertEquals((int)52, (int)b[2 + off]);
        Assertions.assertEquals((int)18, (int)b[3 + off]);
        Assertions.assertEquals((byte)9, (byte)b[4 + off]);
        Assertions.assertEquals((byte)-17, (byte)b[5 + off]);
        Assertions.assertEquals((byte)-51, (byte)b[6 + off]);
        Assertions.assertEquals((byte)-85, (byte)b[7 + off]);
    }

    private static void checkSizes(byte[] b) {
        Assertions.assertEquals((int)120, (int)b[0]);
        Assertions.assertEquals((int)86, (int)b[1]);
        Assertions.assertEquals((int)52, (int)b[2]);
        Assertions.assertEquals((int)18, (int)b[3]);
        Assertions.assertEquals((int)0, (int)b[4]);
        Assertions.assertEquals((int)0, (int)b[5]);
        Assertions.assertEquals((int)0, (int)b[6]);
        Assertions.assertEquals((int)0, (int)b[7]);
        Assertions.assertEquals((byte)-17, (byte)b[8]);
        Assertions.assertEquals((byte)-51, (byte)b[9]);
        Assertions.assertEquals((byte)-85, (byte)b[10]);
        Assertions.assertEquals((int)9, (int)b[11]);
        Assertions.assertEquals((int)0, (int)b[12]);
        Assertions.assertEquals((int)0, (int)b[13]);
        Assertions.assertEquals((int)0, (int)b[14]);
        Assertions.assertEquals((int)0, (int)b[15]);
    }

    @Test
    void testReadCDSizesAndOffset() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[24];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        Assertions.assertEquals((Object)SIZE, (Object)f.getSize());
        Assertions.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assertions.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Assertions.assertNull((Object)f.getDiskStartNumber());
    }

    @Test
    void testReadCDSizesOffsetAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[28];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 24, 4);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        Assertions.assertEquals((Object)SIZE, (Object)f.getSize());
        Assertions.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assertions.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Assertions.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    @Test
    void testReadCDSomethingAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[12];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 8, 4);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        Assertions.assertNull((Object)f.getSize());
        Assertions.assertNull((Object)f.getCompressedSize());
        Assertions.assertNull((Object)f.getRelativeHeaderOffset());
        Assertions.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    @Test
    void testReadLFHSizesAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[20];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 16, 4);
        f.parseFromLocalFileData(b, 0, b.length);
        Assertions.assertEquals((Object)SIZE, (Object)f.getSize());
        Assertions.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assertions.assertNull((Object)f.getRelativeHeaderOffset());
        Assertions.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    @Test
    void testReadLFHSizesAndOffset() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[24];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        f.parseFromLocalFileData(b, 0, b.length);
        Assertions.assertEquals((Object)SIZE, (Object)f.getSize());
        Assertions.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assertions.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Assertions.assertNull((Object)f.getDiskStartNumber());
    }

    @Test
    void testReadLFHSizesOffsetAndDisk() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[28];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        System.arraycopy(OFF.getBytes(), 0, b, 16, 8);
        System.arraycopy(DISK.getBytes(), 0, b, 24, 4);
        f.parseFromLocalFileData(b, 0, b.length);
        Assertions.assertEquals((Object)SIZE, (Object)f.getSize());
        Assertions.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assertions.assertEquals((Object)OFF, (Object)f.getRelativeHeaderOffset());
        Assertions.assertEquals((Object)DISK, (Object)f.getDiskStartNumber());
    }

    @Test
    void testReadLFHSizesOnly() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[16];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        System.arraycopy(CSIZE.getBytes(), 0, b, 8, 8);
        f.parseFromLocalFileData(b, 0, b.length);
        Assertions.assertEquals((Object)SIZE, (Object)f.getSize());
        Assertions.assertEquals((Object)CSIZE, (Object)f.getCompressedSize());
        Assertions.assertNull((Object)f.getRelativeHeaderOffset());
        Assertions.assertNull((Object)f.getDiskStartNumber());
    }

    @Test
    void testReparseCDSingleEightByteData() throws ZipException {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField();
        byte[] b = new byte[8];
        System.arraycopy(SIZE.getBytes(), 0, b, 0, 8);
        f.parseFromCentralDirectoryData(b, 0, b.length);
        f.reparseCentralDirectoryData(true, false, false, false);
        Assertions.assertEquals((Object)SIZE, (Object)f.getSize());
        Assertions.assertNull((Object)f.getCompressedSize());
        Assertions.assertNull((Object)f.getRelativeHeaderOffset());
        Assertions.assertNull((Object)f.getDiskStartNumber());
        f.setSize(null);
        f.reparseCentralDirectoryData(false, true, false, false);
        Assertions.assertNull((Object)f.getSize());
        Assertions.assertEquals((Object)SIZE, (Object)f.getCompressedSize());
        Assertions.assertNull((Object)f.getRelativeHeaderOffset());
        Assertions.assertNull((Object)f.getDiskStartNumber());
        f.setCompressedSize(null);
        f.reparseCentralDirectoryData(false, false, true, false);
        Assertions.assertNull((Object)f.getSize());
        Assertions.assertNull((Object)f.getCompressedSize());
        Assertions.assertEquals((Object)SIZE, (Object)f.getRelativeHeaderOffset());
        Assertions.assertNull((Object)f.getDiskStartNumber());
    }

    @Test
    void testWriteCDOnlySizes() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE);
        Assertions.assertEquals((Object)new ZipShort(16), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Assertions.assertEquals((int)16, (int)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
    }

    @Test
    void testWriteCDSizeAndDisk() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE, null, DISK);
        Assertions.assertEquals((Object)new ZipShort(20), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Assertions.assertEquals((int)20, (int)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
        Zip64ExtendedInformationExtraFieldTest.checkDisk(b, 16);
    }

    @Test
    void testWriteCDSizeAndOffset() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE, OFF, null);
        Assertions.assertEquals((Object)new ZipShort(24), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Assertions.assertEquals((int)24, (int)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
        Zip64ExtendedInformationExtraFieldTest.checkOffset(b, 16);
    }

    @Test
    void testWriteCDSizeOffsetAndDisk() {
        Zip64ExtendedInformationExtraField f = new Zip64ExtendedInformationExtraField(SIZE, CSIZE, OFF, DISK);
        Assertions.assertEquals((Object)new ZipShort(28), (Object)f.getCentralDirectoryLength());
        byte[] b = f.getCentralDirectoryData();
        Assertions.assertEquals((int)28, (int)b.length);
        Zip64ExtendedInformationExtraFieldTest.checkSizes(b);
        Zip64ExtendedInformationExtraFieldTest.checkOffset(b, 16);
        Zip64ExtendedInformationExtraFieldTest.checkDisk(b, 24);
    }
}

