/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.compressors.xz.XZUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class ZipCompressMethodXzTest
extends AbstractTest {
    private static final int DEFAULT_LEVEL = 6;
    @TempDir
    static Path tempDir;

    ZipCompressMethodXzTest() {
    }

    private static void compress(InputStream input, OutputStream output) throws IOException {
        XZCompressorOutputStream outputStream = new XZCompressorOutputStream(output, 6);
        IOUtils.copyLarge((InputStream)input, (OutputStream)outputStream);
        outputStream.flush();
    }

    @Test
    void testXzInputStream() throws IOException {
        Path file = ZipCompressMethodXzTest.getPath("org/apache/commons/compress/zip/test-method-xz.zip");
        try (ZipFile zip = ((ZipFile.Builder)ZipFile.builder().setPath(file)).get();){
            ZipArchiveEntry entry = (ZipArchiveEntry)zip.getEntries().nextElement();
            Assertions.assertEquals((Object)"LICENSE.txt", (Object)entry.getName());
            Assertions.assertTrue((boolean)zip.canReadEntryData(entry));
            Assertions.assertEquals((int)ZipMethod.XZ.getCode(), (int)entry.getMethod());
            try (InputStream inputStream = zip.getInputStream(entry);){
                long actualSize = entry.getSize();
                byte[] buf = new byte[(int)actualSize];
                inputStream.read(buf);
                String text = new String(buf);
                Assertions.assertTrue((boolean)text.startsWith("                                 Apache License"), (String)text);
                Assertions.assertTrue((boolean)text.endsWith("   limitations under the License.\n"), (String)text);
                Assertions.assertEquals((int)11357, (int)text.length());
            }
        }
    }

    @Test
    void testXzMethodInZipFile() throws IOException {
        String zipContentFile = "testXzMethodInZipFile.txt";
        byte[] text = "The quick brown fox jumps over the lazy dog".getBytes(StandardCharsets.UTF_8);
        Path file = tempDir.resolve("testXzMethodInZipFile.zip");
        try (ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream(file, new OpenOption[0]);){
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry("testXzMethodInZipFile.txt");
            archiveEntry.setMethod(ZipMethod.XZ.getCode());
            archiveEntry.setSize((long)text.length);
            zipOutputStream.putArchiveEntry(archiveEntry);
            ZipCompressMethodXzTest.compress(new ByteArrayInputStream(text), (OutputStream)zipOutputStream);
            zipOutputStream.closeArchiveEntry();
        }
        try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setPath(file)).get();){
            ZipArchiveEntry entry = zipFile.getEntry("testXzMethodInZipFile.txt");
            Assertions.assertEquals((int)entry.getMethod(), (int)ZipMethod.XZ.getCode());
            InputStream inputStream = zipFile.getInputStream(entry);
            Assertions.assertTrue((boolean)(inputStream instanceof XZCompressorInputStream));
            long dataOffset = entry.getDataOffset();
            int uncompressedSize = (int)entry.getSize();
            Assertions.assertEquals((int)text.length, (int)uncompressedSize);
            byte[] uncompressedData = new byte[uncompressedSize];
            inputStream.read(uncompressedData, 0, uncompressedSize);
            Assertions.assertEquals((Object)new String(text), (Object)new String(uncompressedData));
            try (InputStream fileInputStream = Files.newInputStream(file, new OpenOption[0]);){
                fileInputStream.skip(dataOffset);
                byte[] compressedData = new byte[6];
                fileInputStream.read(compressedData);
                Assertions.assertTrue((boolean)XZUtils.matches((byte[])compressedData, (int)6));
            }
        }
    }

    @Test
    void testXzMethodWriteRead() throws IOException {
        String zipContentFile = "testXzMethodWriteRead.txt";
        byte[] text = "The quick brown fox jumps over the lazy dog".getBytes(StandardCharsets.UTF_8);
        Path file = tempDir.resolve("testXzMethodWriteRead.zip");
        try (ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream(file, new OpenOption[0]);){
            ZipArchiveEntry archiveEntry = new ZipArchiveEntry("testXzMethodWriteRead.txt");
            archiveEntry.setMethod(ZipMethod.XZ.getCode());
            archiveEntry.setSize((long)text.length);
            zipOutputStream.putArchiveEntry(archiveEntry);
            ZipCompressMethodXzTest.compress(new ByteArrayInputStream(text), (OutputStream)zipOutputStream);
            zipOutputStream.closeArchiveEntry();
        }
        try (ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setPath(file)).get();){
            ZipArchiveEntry entry = zipFile.getEntry("testXzMethodWriteRead.txt");
            Assertions.assertEquals((int)entry.getMethod(), (int)ZipMethod.XZ.getCode());
            InputStream inputStream = zipFile.getInputStream(entry);
            Assertions.assertTrue((boolean)(inputStream instanceof XZCompressorInputStream));
        }
    }
}

