/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.web;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServlet;
import java.util.Properties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.TestAbstractConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.web.JakartaServletContextConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestJakartaServletContextConfiguration
extends TestAbstractConfiguration {
    @Override
    protected AbstractConfiguration getConfiguration() {
        Properties parameters = new Properties();
        parameters.setProperty("key1", "value1");
        parameters.setProperty("key2", "value2");
        parameters.setProperty("list", "value1, value2");
        parameters.setProperty("listesc", "value1\\,value2");
        ServletContext context = this.mockServletConfig(parameters);
        final ServletConfig config = (ServletConfig)Mockito.mock(ServletConfig.class);
        Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
        HttpServlet servlet = new HttpServlet(){
            private static final long serialVersionUID = 1L;

            public ServletConfig getServletConfig() {
                return config;
            }
        };
        JakartaServletContextConfiguration resultConfig = new JakartaServletContextConfiguration((Servlet)servlet);
        resultConfig.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        return resultConfig;
    }

    @Override
    protected AbstractConfiguration getEmptyConfiguration() {
        ServletContext context = this.mockServletConfig(new Properties());
        return new JakartaServletContextConfiguration(context);
    }

    private ServletContext mockServletConfig(Properties parameters) {
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getInitParameterNames()).thenAnswer(invocation -> parameters.keys());
        Mockito.when((Object)context.getInitParameter((String)ArgumentMatchers.any())).thenAnswer(invocation -> {
            String name = (String)invocation.getArgument(0, String.class);
            return parameters.getProperty(name);
        });
        return context;
    }

    @Override
    @Test
    public void testAddPropertyDirect() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testAddPropertyDirect());
    }

    @Override
    @Test
    public void testClearProperty() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> super.testClearProperty());
    }

    @Override
    @Test
    public void testContainsValue() {
        Assertions.assertFalse((boolean)this.getConfiguration().containsValue(null));
        Assertions.assertFalse((boolean)this.getConfiguration().containsValue((Object)""));
    }
}

