/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.daemon;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;
import org.apache.commons.daemon.DaemonController;
import org.apache.commons.daemon.DaemonUserSignal;

public class SimpleDaemon
implements Daemon,
Runnable,
DaemonUserSignal {
    private ServerSocket server;
    private Thread thread;
    private DaemonController controller;
    private volatile boolean stopping;
    private String directory;
    private final Vector<Handler> handlers;
    private boolean softReloadSignalled;

    public SimpleDaemon() {
        System.err.println("SimpleDaemon: instance " + this.hashCode() + " created");
        this.handlers = new Vector();
    }

    protected void finalize() {
        System.err.println("SimpleDaemon: instance " + this.hashCode() + " garbage collected");
    }

    public void init(DaemonContext context) throws Exception {
        System.err.println("SimpleDaemon: instance " + this.hashCode() + " init");
        int port = 1200;
        String[] a = context.getArguments();
        if (a.length > 0) {
            port = Integer.parseInt(a[0]);
        }
        this.directory = a.length > 1 ? a[1] : "/tmp";
        System.err.println("SimpleDaemon: loading on port " + port);
        this.controller = context.getController();
        this.server = new ServerSocket(port);
        this.thread = new Thread(this);
    }

    public void start() {
        System.err.println("SimpleDaemon: starting");
        this.thread.start();
    }

    public void stop() throws IOException, InterruptedException {
        System.err.println("SimpleDaemon: stopping");
        this.stopping = true;
        this.server.close();
        this.thread.join(5000L);
        System.err.println("SimpleDaemon: stopped");
    }

    public void destroy() {
        System.err.println("SimpleDaemon: instance " + this.hashCode() + " destroy");
    }

    @Override
    public void run() {
        Handler handler;
        block4: {
            int number = 0;
            System.err.println("SimpleDaemon: started acceptor loop");
            try {
                while (!this.stopping) {
                    this.checkForReload();
                    Socket socket = this.server.accept();
                    this.checkForReload();
                    handler = new Handler(socket, this, this.controller);
                    handler.setConnectionNumber(number++);
                    handler.setDirectoryName(this.directory);
                    new Thread(handler).start();
                }
            }
            catch (IOException e) {
                if (this.stopping) break block4;
                e.printStackTrace(System.err);
            }
        }
        Enumeration<Handler> openhandlers = this.handlers.elements();
        while (openhandlers.hasMoreElements()) {
            handler = openhandlers.nextElement();
            System.err.println("SimpleDaemon: dropping connection " + handler.getConnectionNumber());
            handler.close();
        }
        System.err.println("SimpleDaemon: exiting acceptor loop");
    }

    public void signal() {
        this.softReloadSignalled = true;
    }

    private void checkForReload() {
        if (this.softReloadSignalled) {
            System.err.println("SimpleDaemon: picked up reload, waiting for connections to finish...");
            while (!this.handlers.isEmpty()) {
            }
            System.err.println("SimpleDaemon: all connections have finished, pretending to reload");
            this.softReloadSignalled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHandler(Handler handler) {
        Handler handler2 = handler;
        synchronized (handler2) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHandler(Handler handler) {
        Handler handler2 = handler;
        synchronized (handler2) {
            this.handlers.remove(handler);
        }
    }

    public static class Handler
    implements Runnable {
        private final DaemonController controller;
        private final SimpleDaemon parent;
        private String directory;
        private final Socket socket;
        private int number;

        public Handler(Socket s, SimpleDaemon p, DaemonController c) {
            this.socket = s;
            this.parent = p;
            this.controller = c;
        }

        @Override
        public void run() {
            this.parent.addHandler(this);
            System.err.println("SimpleDaemon: connection " + this.number + " opened from " + this.socket.getInetAddress());
            try {
                InputStream in = this.socket.getInputStream();
                OutputStream out = this.socket.getOutputStream();
                this.handle(in, out);
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            System.err.println("SimpleDaemon: connection " + this.number + " closed");
            this.parent.removeHandler(this);
        }

        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }

        public void setConnectionNumber(int number) {
            this.number = number;
        }

        public int getConnectionNumber() {
            return this.number;
        }

        public void setDirectoryName(String directory) {
            this.directory = directory;
        }

        public String getDirectoryName() {
            return this.directory;
        }

        public void log(String name) throws IOException {
            try (FileOutputStream file = new FileOutputStream(name, true);
                 PrintStream out = new PrintStream(file);){
                out.println(new SimpleDateFormat().format(new Date()));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handle(InputStream in, OutputStream os) {
            PrintStream out = new PrintStream(os);
            try {
                block17: while (true) {
                    if (in.available() == 0) {
                        out.println();
                        out.println("Please select one of the following:");
                        out.println("    1) Shutdown");
                        out.println("    2) Reload");
                        out.println("    3) Create a file");
                        out.println("    4) Disconnect");
                        out.println("    5) Soft reload");
                        out.print("Your choice: ");
                    }
                    int x = in.read();
                    switch (x) {
                        case -1: {
                            return;
                        }
                        case 49: {
                            out.println("Attempting a shutdown...");
                            try {
                                this.controller.shutdown();
                            }
                            catch (IllegalStateException e) {
                                out.println();
                                out.println("Can't shutdown now");
                                e.printStackTrace(out);
                            }
                            continue block17;
                        }
                        case 50: {
                            out.println("Attempting a reload...");
                            try {
                                this.controller.reload();
                            }
                            catch (IllegalStateException e) {
                                out.println();
                                out.println("Can't reload now");
                                e.printStackTrace(out);
                            }
                            continue block17;
                        }
                        case 51: {
                            String name = this.getDirectoryName() + "/SimpleDaemon." + this.getConnectionNumber() + ".tmp";
                            try {
                                this.log(name);
                                out.println("File '" + name + "' created");
                            }
                            catch (IOException e) {
                                e.printStackTrace(out);
                            }
                            continue block17;
                        }
                        case 52: {
                            out.println("Disconnecting...");
                            return;
                        }
                        case 53: {
                            out.println("Reloading configuration...");
                            this.parent.signal();
                            return;
                        }
                        case 10: 
                        case 13: {
                            continue block17;
                        }
                    }
                    out.println("Unknown option '" + (char)x + "'");
                }
            }
            catch (IOException e) {
                System.err.println("SimpleDaemon: IOException in connection " + this.getConnectionNumber());
                return;
            }
        }
    }
}

