/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.UnaryOperator;
import org.apache.commons.geometry.core.internal.DoubleFunction2N;
import org.apache.commons.geometry.core.internal.SimpleTupleFormat;
import org.apache.commons.geometry.euclidean.EuclideanVectorSum;
import org.apache.commons.geometry.euclidean.MultiDimensionalEuclideanVector;
import org.apache.commons.geometry.euclidean.internal.Vectors;
import org.apache.commons.numbers.core.Precision;

public class Vector2D
extends MultiDimensionalEuclideanVector<Vector2D> {
    public static final Vector2D ZERO = new Vector2D(0.0, 0.0);
    public static final Vector2D NaN = new Vector2D(Double.NaN, Double.NaN);
    public static final Vector2D POSITIVE_INFINITY = new Vector2D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Vector2D NEGATIVE_INFINITY = new Vector2D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    public static final Comparator<Vector2D> COORDINATE_ASCENDING_ORDER = (a, b) -> {
        int cmp = 0;
        if (a != null && b != null) {
            cmp = Double.compare(a.getX(), b.getX());
            if (cmp == 0) {
                cmp = Double.compare(a.getY(), b.getY());
            }
        } else if (a != null) {
            cmp = -1;
        } else if (b != null) {
            cmp = 1;
        }
        return cmp;
    };
    private final double x;
    private final double y;

    private Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double[] toArray() {
        return new double[]{this.x, this.y};
    }

    public int getDimension() {
        return 2;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y);
    }

    public boolean isInfinite() {
        return !this.isNaN() && (Double.isInfinite(this.x) || Double.isInfinite(this.y));
    }

    public boolean isFinite() {
        return Double.isFinite(this.x) && Double.isFinite(this.y);
    }

    @Override
    public Vector2D vectorTo(Vector2D v) {
        return v.subtract(this);
    }

    @Override
    public Unit directionTo(Vector2D v) {
        return this.vectorTo(v).normalize();
    }

    @Override
    public Vector2D lerp(Vector2D p, double t) {
        return Sum.create().addScaled(1.0 - t, this).addScaled(t, p).get();
    }

    public Vector2D getZero() {
        return ZERO;
    }

    public double norm() {
        return Vectors.norm(this.x, this.y);
    }

    public double normSq() {
        return Vectors.normSq(this.x, this.y);
    }

    public Vector2D withNorm(double magnitude) {
        double invNorm = 1.0 / this.getCheckedNorm();
        return new Vector2D(magnitude * this.x * invNorm, magnitude * this.y * invNorm);
    }

    public Vector2D add(Vector2D v) {
        return new Vector2D(this.x + v.x, this.y + v.y);
    }

    public Vector2D add(double factor, Vector2D v) {
        return new Vector2D(this.x + factor * v.x, this.y + factor * v.y);
    }

    public Vector2D subtract(Vector2D v) {
        return new Vector2D(this.x - v.x, this.y - v.y);
    }

    public Vector2D subtract(double factor, Vector2D v) {
        return new Vector2D(this.x - factor * v.x, this.y - factor * v.y);
    }

    public Vector2D negate() {
        return new Vector2D(-this.x, -this.y);
    }

    public Unit normalize() {
        return Unit.from(this.x, this.y);
    }

    public Unit normalizeOrNull() {
        return Unit.tryCreateNormalized(this.x, this.y, false);
    }

    public Vector2D multiply(double a) {
        return new Vector2D(a * this.x, a * this.y);
    }

    public double distance(Vector2D v) {
        return Vectors.norm(this.x - v.x, this.y - v.y);
    }

    public double distanceSq(Vector2D v) {
        return Vectors.normSq(this.x - v.x, this.y - v.y);
    }

    public double dot(Vector2D v) {
        return Vectors.linearCombination(this.x, v.x, this.y, v.y);
    }

    public double angle(Vector2D v) {
        double threshold;
        double normProduct = this.getCheckedNorm() * v.getCheckedNorm();
        double dot = this.dot(v);
        if (dot < -(threshold = normProduct * 0.9999) || dot > threshold) {
            double n = Math.abs(Vectors.linearCombination(this.x, v.y, -this.y, v.x));
            if (dot >= 0.0) {
                return Math.asin(n / normProduct);
            }
            return Math.PI - Math.asin(n / normProduct);
        }
        return Math.acos(dot / normProduct);
    }

    @Override
    public Vector2D project(Vector2D base) {
        return this.getComponent(base, false, Vector2D::new);
    }

    @Override
    public Vector2D reject(Vector2D base) {
        return this.getComponent(base, true, Vector2D::new);
    }

    @Override
    public Unit orthogonal() {
        return Unit.from(-this.y, this.x);
    }

    @Override
    public Unit orthogonal(Vector2D dir) {
        return (Unit)dir.getComponent(this, true, Unit::from);
    }

    public double signedArea(Vector2D v) {
        return Vectors.linearCombination(this.x, v.y, -this.y, v.x);
    }

    public Vector2D transform(UnaryOperator<Vector2D> fn) {
        return (Vector2D)fn.apply(this);
    }

    @Override
    public boolean eq(Vector2D vec, Precision.DoubleEquivalence precision) {
        return precision.eq(this.x, vec.x) && precision.eq(this.y, vec.y);
    }

    public int hashCode() {
        if (this.isNaN()) {
            return 542;
        }
        return 122 * (76 * Double.hashCode(this.x) + Double.hashCode(this.y));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Vector2D) {
            Vector2D rhs = (Vector2D)other;
            if (rhs.isNaN()) {
                return this.isNaN();
            }
            return Double.compare(this.x, rhs.x) == 0 && Double.compare(this.y, rhs.y) == 0;
        }
        return false;
    }

    public String toString() {
        return SimpleTupleFormat.getDefault().format(this.x, this.y);
    }

    private <T extends Vector2D> T getComponent(Vector2D base, boolean reject, DoubleFunction2N<T> factory) {
        double aDotB = this.dot(base);
        double baseMagSq = Vectors.checkedNorm(base.normSq());
        double scale = aDotB / baseMagSq;
        double projX = scale * base.x;
        double projY = scale * base.y;
        if (reject) {
            return (T)((Vector2D)factory.apply(this.x - projX, this.y - projY));
        }
        return (T)((Vector2D)factory.apply(projX, projY));
    }

    public static Vector2D of(double x, double y) {
        return new Vector2D(x, y);
    }

    public static Vector2D of(double[] v) {
        if (v.length != 2) {
            throw new IllegalArgumentException("Dimension mismatch: " + v.length + " != 2");
        }
        return new Vector2D(v[0], v[1]);
    }

    public static Vector2D parse(String str) {
        return (Vector2D)SimpleTupleFormat.getDefault().parse(str, Vector2D::new);
    }

    public static Vector2D max(Vector2D first, Vector2D ... more) {
        return Vector2D.computeMax(first, Arrays.asList(more).iterator());
    }

    public static Vector2D max(Iterable<Vector2D> vecs) {
        Iterator<Vector2D> it = vecs.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Cannot compute vector max: no vectors given");
        }
        return Vector2D.computeMax(it.next(), it);
    }

    private static Vector2D computeMax(Vector2D first, Iterator<? extends Vector2D> more) {
        double x = first.getX();
        double y = first.getY();
        while (more.hasNext()) {
            Vector2D vec = more.next();
            x = Math.max(x, vec.getX());
            y = Math.max(y, vec.getY());
        }
        return Vector2D.of(x, y);
    }

    public static Vector2D min(Vector2D first, Vector2D ... more) {
        return Vector2D.computeMin(first, Arrays.asList(more).iterator());
    }

    public static Vector2D min(Iterable<Vector2D> vecs) {
        Iterator<Vector2D> it = vecs.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Cannot compute vector min: no vectors given");
        }
        return Vector2D.computeMin(it.next(), it);
    }

    private static Vector2D computeMin(Vector2D first, Iterator<? extends Vector2D> more) {
        double x = first.getX();
        double y = first.getY();
        while (more.hasNext()) {
            Vector2D vec = more.next();
            x = Math.min(x, vec.getX());
            y = Math.min(y, vec.getY());
        }
        return Vector2D.of(x, y);
    }

    public static Vector2D centroid(Vector2D first, Vector2D ... more) {
        return Vector2D.computeCentroid(first, Arrays.asList(more).iterator());
    }

    public static Vector2D centroid(Iterable<Vector2D> pts) {
        Iterator<Vector2D> it = pts.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Cannot compute centroid: no points given");
        }
        return Vector2D.computeCentroid(it.next(), it);
    }

    private static Vector2D computeCentroid(Vector2D first, Iterator<? extends Vector2D> more) {
        Sum sum = Sum.of(first);
        int count = 1;
        while (more.hasNext()) {
            sum.add(more.next());
            ++count;
        }
        return sum.get().multiply(1.0 / (double)count);
    }

    public static final class Sum
    extends EuclideanVectorSum<Vector2D> {
        private final org.apache.commons.numbers.core.Sum xsum;
        private final org.apache.commons.numbers.core.Sum ysum;

        Sum(Vector2D initial) {
            this.xsum = org.apache.commons.numbers.core.Sum.of((double)initial.x);
            this.ysum = org.apache.commons.numbers.core.Sum.of((double)initial.y);
        }

        public Sum add(Vector2D vec) {
            this.xsum.add(vec.x);
            this.ysum.add(vec.y);
            return this;
        }

        public Sum addScaled(double scale, Vector2D vec) {
            this.xsum.addProduct(scale, vec.x);
            this.ysum.addProduct(scale, vec.y);
            return this;
        }

        @Override
        public Vector2D get() {
            return Vector2D.of(this.xsum.getAsDouble(), this.ysum.getAsDouble());
        }

        public static Sum create() {
            return new Sum(ZERO);
        }

        public static Sum of(Vector2D initial) {
            return new Sum(initial);
        }

        public static Sum of(Vector2D first, Vector2D ... more) {
            Sum s = new Sum(first);
            for (Vector2D v : more) {
                s.add(v);
            }
            return s;
        }
    }

    public static final class Unit
    extends Vector2D {
        public static final Unit PLUS_X = new Unit(1.0, 0.0);
        public static final Unit MINUS_X = new Unit(-1.0, 0.0);
        public static final Unit PLUS_Y = new Unit(0.0, 1.0);
        public static final Unit MINUS_Y = new Unit(0.0, -1.0);
        private static final double UNSCALED_MAX = 3.273390607896142E150;
        private static final double SCALE_UP_FACTOR = 4.149515568880993E180;
        private static final double SCALE_DOWN_FACTOR = 2.409919865102884E-181;

        private Unit(double x, double y) {
            super(x, y);
        }

        @Override
        public double norm() {
            return 1.0;
        }

        @Override
        public double normSq() {
            return 1.0;
        }

        @Override
        public Unit normalize() {
            return this;
        }

        @Override
        public Unit normalizeOrNull() {
            return this;
        }

        @Override
        public Unit orthogonal() {
            return new Unit(-this.getY(), this.getX());
        }

        @Override
        public Vector2D withNorm(double mag) {
            return this.multiply(mag);
        }

        @Override
        public Unit negate() {
            return new Unit(-this.getX(), -this.getY());
        }

        public static Unit from(double x, double y) {
            return Unit.tryCreateNormalized(x, y, true);
        }

        public static Unit from(Vector2D v) {
            return v instanceof Unit ? (Unit)v : Unit.from(v.getX(), v.getY());
        }

        private static Unit tryCreateNormalized(double x, double y, boolean throwOnFailure) {
            double scaledY;
            double scaledX;
            double norm = Vectors.norm(x, y);
            double normInv = 1.0 / norm;
            if (Vectors.isRealNonZero(normInv)) {
                return new Unit(x * normInv, y * normInv);
            }
            double maxCoord = Math.max(Math.abs(x), Math.abs(y));
            if (maxCoord > 3.273390607896142E150) {
                scaledX = x * 2.409919865102884E-181;
                scaledY = y * 2.409919865102884E-181;
            } else {
                scaledX = x * 4.149515568880993E180;
                scaledY = y * 4.149515568880993E180;
            }
            double scaledNormInv = 1.0 / Vectors.norm(scaledX, scaledY);
            if (Vectors.isRealNonZero(scaledNormInv)) {
                return new Unit(scaledX * scaledNormInv, scaledY * scaledNormInv);
            }
            if (throwOnFailure) {
                throw Vectors.illegalNorm(norm);
            }
            return null;
        }
    }
}

