/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.common.AllocationRequestException;
import org.apache.commons.imaging.formats.png.AbstractPngTest;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.formats.png.PngWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngImageParserTest
extends AbstractPngTest {
    private static byte[] getPngImageBytes(BufferedImage image, PngImagingParameters params) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            new PngWriter().writeImage(image, (OutputStream)os, params, null);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    @Test
    public void testGetImageSize() {
        byte[] bytes = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 127, -1, -1, -11, 73, 72, 68, 82};
        Assertions.assertThrows(AllocationRequestException.class, () -> new PngImageParser().getImageSize(bytes));
    }

    @Test
    public void testNoPalette() throws IOException {
        BufferedImage image = new BufferedImage(100, 100, 1);
        image.setRGB(1, 1, 0xFFFFFF);
        PngImagingParameters params = new PngImagingParameters();
        byte[] bytes = PngImageParserTest.getPngImageBytes(image, params);
        ImageInfo imageInfo = new PngImageParser().getImageInfo(bytes, null);
        Assertions.assertFalse((boolean)imageInfo.usesPalette());
    }

    @Test
    public void testPalette() throws IOException {
        BufferedImage image = new BufferedImage(100, 100, 1);
        image.setRGB(1, 1, 0xFFFFFF);
        PngImagingParameters params = new PngImagingParameters();
        params.setForceIndexedColor(true);
        byte[] bytes = PngImageParserTest.getPngImageBytes(image, params);
        ImageInfo imageInfo = new PngImageParser().getImageInfo(bytes, null);
        Assertions.assertTrue((boolean)imageInfo.usesPalette());
    }
}

