/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.util.Comparator;

public abstract class AbstractTiffElement {
    public static final Comparator<AbstractTiffElement> COMPARATOR = Comparator.comparingLong(e -> e.offset);
    public final long offset;
    public final int length;

    public AbstractTiffElement(long offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    public abstract String getElementDescription();

    public static final class Stub
    extends AbstractTiffElement {
        public Stub(long offset, int length) {
            super(offset, length);
        }

        @Override
        public String getElementDescription() {
            return "Element, offset: " + this.offset + ", length: " + this.length + ", last: " + (this.offset + (long)this.length);
        }
    }

    public static abstract class DataElement
    extends AbstractTiffElement {
        private final byte[] data;

        public DataElement(long offset, int length, byte[] data) {
            super(offset, length);
            this.data = data;
        }

        public byte[] getData() {
            return (byte[])this.data.clone();
        }

        public int getDataLength() {
            return this.data.length;
        }
    }
}

