/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.FieldButcherArrayProvider;
import org.apache.commons.math3.ode.nonstiff.GillFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.GillFieldStepInterpolator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldStepInterpolator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldStepInterpolatorAbstractTest;
import org.apache.commons.math3.util.Decimal64Field;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GillFieldStepInterpolatorTest
extends RungeKuttaFieldStepInterpolatorAbstractTest {
    @Override
    protected <T extends RealFieldElement<T>> RungeKuttaFieldStepInterpolator<T> createInterpolator(Field<T> field, boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldODEStateAndDerivative<T> softPreviousState, FieldODEStateAndDerivative<T> softCurrentState, FieldEquationsMapper<T> mapper) {
        return new GillFieldStepInterpolator(field, forward, yDotK, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, mapper);
    }

    @Override
    protected <T extends RealFieldElement<T>> FieldButcherArrayProvider<T> createButcherArrayProvider(Field<T> field) {
        return new GillFieldIntegrator(field, (RealFieldElement)field.getOne());
    }

    @Override
    @Test
    public void interpolationAtBounds() {
        this.doInterpolationAtBounds(Decimal64Field.getInstance(), 1.0E-15);
    }

    @Override
    @Test
    public void interpolationInside() {
        this.doInterpolationInside(Decimal64Field.getInstance(), 2.6E-7, 3.6E-6);
    }

    @Override
    @Test
    public void nonFieldInterpolatorConsistency() {
        this.doNonFieldInterpolatorConsistency(Decimal64Field.getInstance(), 1.4E-17, 1.0E-50, 3.4E-16, 2.1E-17);
    }
}

