/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.LastModifiedTests;
import org.apache.commons.vfs2.VfsTestUtils;
import org.junit.Test;

public class FtpMdtmOnLastModifiedTests
extends LastModifiedTests {
    @Test
    public void testGetLastModifiedFileExactMatch() throws IOException {
        String fileName = "file1.txt";
        FileObject readFolder = this.getReadFolder();
        FileObject fileObject = readFolder.resolveFile("file1.txt");
        long lastModifiedTimeMillis = fileObject.getContent().getLastModifiedTime();
        FileTime lastModifiedTime = Files.getLastModifiedTime(Paths.get(VfsTestUtils.getTestDirectory(), "read-tests", "file1.txt"), new LinkOption[0]);
        if (SystemUtils.IS_JAVA_1_8) {
            this.assertDeltaMillis("file1.txt", lastModifiedTimeMillis, lastModifiedTimeMillis, lastModifiedTimeMillis);
        } else {
            this.assertEqualMillis("getLastModified on " + fileObject, lastModifiedTime.toMillis(), lastModifiedTimeMillis);
        }
    }
}

