/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.privilizer;

import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.weaver.privilizer.FieldAccess;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilizer;
import org.apache.commons.weaver.privilizer.Privilizing;
import org.apache.commons.weaver.privilizer._asm.ClassReader;
import org.apache.commons.weaver.privilizer._asm.ClassVisitor;
import org.apache.commons.weaver.privilizer._asm.Handle;
import org.apache.commons.weaver.privilizer._asm.Label;
import org.apache.commons.weaver.privilizer._asm.MethodVisitor;
import org.apache.commons.weaver.privilizer._asm.Type;
import org.apache.commons.weaver.privilizer._asm.commons.AdviceAdapter;
import org.apache.commons.weaver.privilizer._asm.commons.Method;
import org.apache.commons.weaver.privilizer._asm.tree.ClassNode;
import org.apache.commons.weaver.privilizer._asm.tree.FieldNode;
import org.apache.commons.weaver.privilizer._asm.tree.MethodNode;
import org.apache.commons.weaver.privilizer._lang3.ArrayUtils;
import org.apache.commons.weaver.privilizer._lang3.StringUtils;
import org.apache.commons.weaver.privilizer._lang3.Validate;
import org.apache.commons.weaver.privilizer._lang3.tuple.Pair;

class BlueprintingVisitor
extends Privilizer.PrivilizerClassVisitor {
    static final Type LAMBDA_METAFACTORY = Type.getType(LambdaMetafactory.class);
    final Map<Pair<Type, Method>, MethodNode> blueprintRegistry;
    final Map<Pair<Type, String>, FieldAccess> fieldAccessMap;
    private final Set<Type> blueprintTypes;
    private final Map<Pair<Type, Method>, String> importedMethods;
    private final Map<Type, TypeInfo> typeInfoCache;
    private final ClassVisitor nextVisitor;

    static Pair<Type, Method> methodKey(String owner, String name, String desc) {
        return Pair.of(Type.getObjectType(owner), new Method(name, desc));
    }

    BlueprintingVisitor(Privilizer privilizer, ClassVisitor nextVisitor, Privilizing config) {
        Privilizer privilizer2 = privilizer;
        privilizer2.getClass();
        super((ClassVisitor)new ClassNode(393216));
        this.blueprintRegistry = new HashMap<Pair<Type, Method>, MethodNode>();
        this.fieldAccessMap = new HashMap<Pair<Type, String>, FieldAccess>();
        this.blueprintTypes = new HashSet<Type>();
        this.importedMethods = new HashMap<Pair<Type, Method>, String>();
        this.typeInfoCache = new HashMap<Type, TypeInfo>();
        this.nextVisitor = nextVisitor;
        for (Privilizing.CallTo callTo : config.value()) {
            Type blueprintType = Type.getType(callTo.value());
            this.blueprintTypes.add(blueprintType);
            HashSet<String> methodNames = new HashSet<String>(Arrays.asList(callTo.methods()));
            this.typeInfo((Type)blueprintType).methods.entrySet().stream().filter(e -> methodNames.isEmpty() || methodNames.contains(((Method)e.getKey()).getName())).forEach(e -> this.blueprintRegistry.put(Pair.of(blueprintType, e.getKey()), (MethodNode)e.getValue()));
        }
    }

    TypeInfo typeInfo(Type type) {
        return this.typeInfoCache.computeIfAbsent(type, k -> {
            ClassNode classNode = this.read(k.getClassName());
            return new TypeInfo(classNode.access, classNode.superName, classNode.fields.stream().collect(Collectors.toMap(f -> f.name, Function.identity())), classNode.methods.stream().collect(Collectors.toMap(m -> new Method(m.name, m.desc), Function.identity())));
        });
    }

    private ClassNode read(String className) {
        ClassNode result = new ClassNode(393216);
        try (InputStream bytecode = this.privilizer().env.getClassfile(className).getInputStream();){
            new ClassReader(bytecode).accept(result, 10);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Validate.isTrue(!this.blueprintTypes.contains(Type.getObjectType(name)), "Class %s cannot declare itself as a blueprint!", name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor toWrap = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodInvocationHandler(toWrap){

            @Override
            boolean shouldImport(Pair<Type, Method> methodKey) {
                return BlueprintingVisitor.this.blueprintRegistry.containsKey(methodKey);
            }
        };
    }

    String importMethod(Pair<Type, Method> key) {
        if (this.importedMethods.containsKey(key)) {
            return this.importedMethods.get(key);
        }
        String result = key.getLeft().getInternalName().replace('/', '_') + "$$" + key.getRight().getName();
        this.importedMethods.put(key, result);
        this.privilizer().env.debug("importing %s#%s as %s", new Object[]{key.getLeft().getClassName(), key.getRight(), result});
        int access = 4106;
        MethodNode source = this.typeInfo((Type)key.getLeft()).methods.get(key.getRight());
        String[] exceptions = source.exceptions.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        final LinkedHashSet fieldAccesses = new LinkedHashSet();
        source.accept(new MethodVisitor(393216){

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                FieldAccess fieldAccess = BlueprintingVisitor.this.fieldAccess(Type.getObjectType(owner), name);
                super.visitFieldInsn(opcode, owner, name, desc);
                if (!Modifier.isPublic(fieldAccess.access)) {
                    fieldAccesses.add(fieldAccess);
                }
            }
        });
        MethodNode withAccessibleAdvice = new MethodNode(4106, result, source.desc, source.signature, exceptions);
        MethodVisitor mv = new NestedMethodInvocationHandler(withAccessibleAdvice, key);
        if (!fieldAccesses.isEmpty()) {
            mv = new AccessibleAdvisor(mv, 4106, result, source.desc, new ArrayList<FieldAccess>(fieldAccesses));
        }
        source.accept(mv);
        if (!Modifier.isPrivate(source.access)) {
            withAccessibleAdvice.visitAnnotation(Type.getType(Privileged.class).getDescriptor(), false).visitEnd();
        }
        withAccessibleAdvice.accept(this.cv);
        return result;
    }

    FieldAccess fieldAccess(Type owner, String name) {
        return this.fieldAccessMap.computeIfAbsent(Pair.of(owner, name), k -> {
            FieldNode fieldNode = this.typeInfo((Type)((Type)k.getLeft())).fields.get(k.getRight());
            Validate.validState(fieldNode != null, "Could not locate %s.%s", ((Type)k.getLeft()).getClassName(), k.getRight());
            return new FieldAccess(fieldNode.access, (Type)k.getLeft(), fieldNode.name, Type.getType(fieldNode.desc));
        });
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        ((ClassNode)this.cv).accept(this.nextVisitor);
    }

    private class AccessibleAdvisor
    extends AdviceAdapter {
        final Type bitSetType;
        final Type classType;
        final Type fieldType;
        final Type fieldArrayType;
        final Type stringType;
        final List<FieldAccess> fieldAccesses;
        final Label begin;
        int localFieldArray;
        int bitSet;
        int fieldCounter;

        AccessibleAdvisor(MethodVisitor mvr, int access, String name, String desc, List<FieldAccess> fieldAccesses) {
            super(393216, mvr, access, name, desc);
            this.bitSetType = Type.getType(BitSet.class);
            this.classType = Type.getType(Class.class);
            this.fieldType = Type.getType(Field.class);
            this.fieldArrayType = Type.getType(Field[].class);
            this.stringType = Type.getType(String.class);
            this.begin = new Label();
            this.fieldAccesses = fieldAccesses;
        }

        @Override
        protected void onMethodEnter() {
            this.localFieldArray = this.newLocal(this.fieldArrayType);
            this.bitSet = this.newLocal(this.bitSetType);
            this.fieldCounter = this.newLocal(Type.INT_TYPE);
            this.push(this.fieldAccesses.size());
            this.newArray(this.fieldArrayType.getElementType());
            this.storeLocal(this.localFieldArray);
            this.newInstance(this.bitSetType);
            this.dup();
            this.push(this.fieldAccesses.size());
            this.invokeConstructor(this.bitSetType, Method.getMethod("void <init>(int)"));
            this.storeLocal(this.bitSet);
            this.push(0);
            this.storeLocal(this.fieldCounter);
            for (FieldAccess access : this.fieldAccesses) {
                this.prehandle(access);
                this.iinc(this.fieldCounter, 1);
            }
            this.mark(this.begin);
        }

        private void prehandle(FieldAccess access) {
            this.visitLdcInsn(access.owner);
            this.push(access.name);
            Label next = new Label();
            this.invokeVirtual(this.classType, new Method("getDeclaredField", this.fieldType, new Type[]{this.stringType}));
            this.dup();
            this.loadLocal(this.localFieldArray);
            this.swap();
            this.loadLocal(this.fieldCounter);
            this.swap();
            this.arrayStore(this.fieldArrayType.getElementType());
            this.dup();
            this.invokeVirtual(this.fieldArrayType.getElementType(), Method.getMethod("boolean isAccessible()"));
            Label setAccessible = new Label();
            this.ifZCmp(153, setAccessible);
            this.pop();
            this.loadLocal(this.bitSet);
            this.loadLocal(this.fieldCounter);
            this.invokeVirtual(this.bitSetType, Method.getMethod("void set(int)"));
            this.goTo(next);
            this.mark(setAccessible);
            this.push(true);
            this.invokeVirtual(this.fieldArrayType.getElementType(), Method.getMethod("void setAccessible(boolean)"));
            this.mark(next);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            Method access;
            Pair<Type, String> key = Pair.of(Type.getObjectType(owner), name);
            FieldAccess fieldAccess = BlueprintingVisitor.this.fieldAccessMap.get(key);
            Validate.isTrue(this.fieldAccesses.contains(fieldAccess), "Cannot find field %s", key);
            int fieldIndex = this.fieldAccesses.indexOf(fieldAccess);
            this.visitInsn(0);
            this.loadLocal(this.localFieldArray);
            this.push(fieldIndex);
            this.arrayLoad(this.fieldArrayType.getElementType());
            this.checkCast(this.fieldType);
            if (opcode == 179) {
                this.swap();
                this.push((String)null);
                this.swap();
                if (fieldAccess.type.getSort() < 9) {
                    this.valueOf(fieldAccess.type);
                }
                access = Method.getMethod("void set(Object, Object)");
            } else {
                access = Method.getMethod("Object get(Object)");
                this.push((String)null);
            }
            this.invokeVirtual(this.fieldType, access);
            if (opcode == 178) {
                this.checkCast(Privilizer.wrap(fieldAccess.type));
                if (fieldAccess.type.getSort() < 9) {
                    this.unbox(fieldAccess.type);
                }
            }
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            Label fny = this.mark();
            Type exceptionType = null;
            this.catchException(this.begin, fny, exceptionType);
            this.onFinally();
            this.throwException();
            super.visitMaxs(maxStack, maxLocals);
        }

        @Override
        protected void onMethodExit(int opcode) {
            if (opcode != 191) {
                this.onFinally();
            }
        }

        private void onFinally() {
            this.push(0);
            this.storeLocal(this.fieldCounter);
            Label test = this.mark();
            Label increment = new Label();
            Label endFinally = new Label();
            this.loadLocal(this.fieldCounter);
            this.push(this.fieldAccesses.size());
            this.ifCmp(Type.INT_TYPE, 156, endFinally);
            this.loadLocal(this.bitSet);
            this.loadLocal(this.fieldCounter);
            this.invokeVirtual(this.bitSetType, Method.getMethod("boolean get(int)"));
            this.ifZCmp(154, increment);
            this.loadLocal(this.localFieldArray);
            this.loadLocal(this.fieldCounter);
            this.arrayLoad(this.fieldArrayType.getElementType());
            this.push(false);
            this.invokeVirtual(this.fieldArrayType.getElementType(), Method.getMethod("void setAccessible(boolean)"));
            this.mark(increment);
            this.iinc(this.fieldCounter, 1);
            this.goTo(test);
            this.mark(endFinally);
        }
    }

    class NestedMethodInvocationHandler
    extends MethodInvocationHandler {
        final Pair<Type, Method> methodKey;
        final Type owner;

        NestedMethodInvocationHandler(MethodVisitor mvr, Pair<Type, Method> methodKey) {
            super(mvr);
            this.methodKey = methodKey;
            this.owner = methodKey.getLeft();
        }

        @Override
        protected void visitNonImportedMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            Type ownerType = Type.getObjectType(owner);
            Method method = new Method(name, desc);
            if (!this.isAccessible(ownerType) || !this.isAccessible(ownerType, method)) {
                throw new IllegalStateException(String.format("Blueprint method %s.%s calls inaccessible method %s.%s", this.owner, this.methodKey.getRight(), owner, method));
            }
            super.visitNonImportedMethodInsn(opcode, owner, name, desc, itf);
        }

        @Override
        protected void validateLambda(Handle handle) {
            super.validateLambda(handle);
            Type ownerType = Type.getObjectType(handle.getOwner());
            Method method = new Method(handle.getName(), handle.getDesc());
            if (!this.isAccessible(ownerType) || !this.isAccessible(ownerType, method)) {
                throw new IllegalStateException(String.format("Blueprint method %s.%s utilizes inaccessible method reference %s::%s", this.owner, this.methodKey.getRight(), handle.getOwner(), method));
            }
        }

        @Override
        boolean shouldImport(Pair<Type, Method> methodKey) {
            Type called = methodKey.getLeft();
            if (called.equals(this.owner)) {
                return true;
            }
            try {
                Class<?> inner = this.load(called);
                Class<?> outer = this.load(this.owner);
                return inner.isAssignableFrom(outer);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        private Class<?> load(Type type) throws ClassNotFoundException {
            return BlueprintingVisitor.this.privilizer().env.classLoader.loadClass(type.getClassName());
        }

        private boolean isAccessible(Type type) {
            TypeInfo typeInfo = BlueprintingVisitor.this.typeInfo(type);
            return this.isAccessible(type, typeInfo.access);
        }

        private boolean isAccessible(Type type, Method method) {
            Type currentType = type;
            while (currentType != null) {
                TypeInfo typeInfo = BlueprintingVisitor.this.typeInfo(currentType);
                MethodNode methodNode = typeInfo.methods.get(method);
                if (methodNode == null) {
                    currentType = Optional.ofNullable(typeInfo.superName).map(Type::getObjectType).orElse(null);
                    continue;
                }
                return this.isAccessible(type, methodNode.access);
            }
            throw new IllegalStateException(String.format("Cannot find method %s.%s", type, method));
        }

        private boolean isAccessible(Type type, int access) {
            if (Modifier.isPublic(access)) {
                return true;
            }
            if (Modifier.isProtected(access) || Modifier.isPrivate(access)) {
                return false;
            }
            return Stream.of(BlueprintingVisitor.this.target, type).map(Type::getInternalName).map(n -> StringUtils.substringBeforeLast(n, "/")).distinct().count() == 1L;
        }
    }

    private abstract class MethodInvocationHandler
    extends MethodVisitor {
        MethodInvocationHandler(MethodVisitor mvr) {
            super(393216, mvr);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            Pair<Type, Method> methodKey;
            if (opcode == 184 && this.shouldImport(methodKey = BlueprintingVisitor.methodKey(owner, name, desc))) {
                String importedName = BlueprintingVisitor.this.importMethod(methodKey);
                super.visitMethodInsn(opcode, BlueprintingVisitor.this.className, importedName, desc, itf);
                return;
            }
            this.visitNonImportedMethodInsn(opcode, owner, name, desc, itf);
        }

        protected void visitNonImportedMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (!this.isLambda(bootstrapMethodHandle) || !this.invokeDynamicImportedMethod(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments)) {
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }
        }

        protected void validateLambda(Handle handle) {
        }

        abstract boolean shouldImport(Pair<Type, Method> var1);

        private boolean isLambda(Handle handle) {
            return handle.getTag() == 6 && LAMBDA_METAFACTORY.getInternalName().equals(handle.getOwner()) && "metafactory".equals(handle.getName());
        }

        private boolean invokeDynamicImportedMethod(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            Handle handle;
            OptionalInt handleIndex = OptionalInt.empty();
            for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
                if (!(bootstrapMethodArguments[i] instanceof Handle)) continue;
                if (handleIndex.isPresent()) {
                    return false;
                }
                handleIndex = OptionalInt.of(i);
            }
            if (handleIndex.isPresent() && (handle = (Handle)bootstrapMethodArguments[handleIndex.getAsInt()]).getTag() == 6) {
                Pair<Type, Method> methodKey = BlueprintingVisitor.methodKey(handle.getOwner(), handle.getName(), handle.getDesc());
                if (this.shouldImport(methodKey)) {
                    String importedName = BlueprintingVisitor.this.importMethod(methodKey);
                    Object[] args = (Object[])bootstrapMethodArguments.clone();
                    args[handleIndex.getAsInt()] = new Handle(handle.getTag(), BlueprintingVisitor.this.className, importedName, handle.getDesc(), false);
                    super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, args);
                    return true;
                }
                this.validateLambda(handle);
            }
            return false;
        }
    }

    static class TypeInfo {
        final int access;
        final String superName;
        final Map<String, FieldNode> fields;
        final Map<Method, MethodNode> methods;

        TypeInfo(int access, String superName, Map<String, FieldNode> fields, Map<Method, MethodNode> methods) {
            this.access = access;
            this.superName = superName;
            this.fields = fields;
            this.methods = methods;
        }
    }
}

