/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.ant._xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MJarSupport {
    private static final boolean SUPPORT_MJAR = Arrays.asList("true", "force").contains(System.getProperty("jdk.util.jar.enableMultiRelease", "true"));
    private static final int MJAR_VERSION = MJarSupport.findMJarVersion();
    private boolean mjar;
    private final Map<String, Clazz> classes = new HashMap<String, Clazz>();

    private static int findMJarVersion() {
        if (!SUPPORT_MJAR) {
            return -1;
        }
        int version = MJarSupport.major(System.getProperty("java.version"));
        Integer jarVersion = MJarSupport.major(System.getProperty("jdk.util.jar.version"));
        if (jarVersion > 0) {
            return Math.min(version, jarVersion);
        }
        return Math.min(7, version);
    }

    private static int major(String version) {
        if (version == null) {
            return -1;
        }
        String[] parts = version.split("\\.");
        try {
            int i = Integer.parseInt(parts[0]);
            if (i == 1 && parts.length > 1) {
                return Integer.parseInt(parts[1]);
            }
            return i;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public boolean isMjar() {
        return this.mjar;
    }

    public Map<String, Clazz> getClasses() {
        return this.classes;
    }

    public void load(InputStream is) throws IOException {
        if (!SUPPORT_MJAR) {
            return;
        }
        this.load(new Manifest(is));
    }

    public void load(Manifest manifest) {
        if (!SUPPORT_MJAR) {
            return;
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainAttributes != null) {
            this.mjar = Boolean.parseBoolean(mainAttributes.getValue("Multi-Release"));
        }
    }

    public void visit(String name) {
        String normalized = name.replace('/', '.');
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        if (normalized.startsWith("META-INF.versions.")) {
            String cname;
            Clazz existing;
            int major;
            String version = normalized.substring("META-INF.versions.".length());
            int nextSep = version.indexOf(46);
            if (nextSep < 0) {
                return;
            }
            String vStr = version.substring(0, nextSep);
            try {
                major = Integer.parseInt(vStr);
                if (major > MJAR_VERSION) {
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                return;
            }
            if (nextSep < version.length() && ((existing = this.classes.get(cname = version.substring(nextSep + 1))) == null || existing.version < major)) {
                this.classes.put(cname, new Clazz(name + (!version.endsWith(".class") ? ".class" : ""), major));
            }
        }
    }

    public static class Clazz {
        private final String path;
        private final int version;

        private Clazz(String path, int version) {
            this.path = path;
            this.version = version;
        }

        public String getPath() {
            return this.path;
        }
    }
}

