/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.weaver.ant._lang3.Validate;
import org.apache.commons.weaver.ant._lang3.builder.HashCodeBuilder;

public abstract class Weavable<SELF extends Weavable<SELF, TARGET>, TARGET>
implements Comparable<SELF>,
AnnotatedElement {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final TARGET target;
    private Set<Annotation> annotations;

    protected Weavable(TARGET target) {
        this.target = target;
        if (target instanceof AnnotatedElement) {
            this.addAnnotations(((AnnotatedElement)target).getAnnotations());
        }
    }

    public final boolean addAnnotations(Annotation ... toAdd) {
        Validate.noNullElements(toAdd);
        return this.addAnnotations(Arrays.asList(toAdd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addAnnotations(Iterable<Annotation> toAdd) {
        if (toAdd == null) {
            return false;
        }
        Weavable weavable = this;
        synchronized (weavable) {
            if (this.annotations == null) {
                this.annotations = new LinkedHashSet<Annotation>();
            }
            boolean result = false;
            for (Annotation ann : toAdd) {
                if (ann == null) continue;
                result = this.annotations.add(ann) || result;
            }
            return result;
        }
    }

    public TARGET getTarget() {
        return this.target;
    }

    @Override
    public final synchronized Annotation[] getAnnotations() {
        if (this.annotations == null) {
            return EMPTY_ANNOTATION_ARRAY;
        }
        return this.annotations.toArray(new Annotation[0]);
    }

    @Override
    public synchronized <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (this.annotations == null) {
            return null;
        }
        for (Annotation prospect : this.annotations) {
            if (!annotationClass.equals(prospect.annotationType())) continue;
            Annotation result = prospect;
            return (T)result;
        }
        return null;
    }

    @Override
    public final Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public String toString() {
        return "Weavable " + this.getTarget().toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return this.getTarget().equals(((Weavable)obj).getTarget());
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getTarget()).toHashCode();
    }
}

