/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.documentation.options;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.OptionCollection;
import org.apache.rat.commandline.Arg;

public abstract class AbstractOption {
    protected static final Pattern PATTERN = Pattern.compile("-(-[a-z0-9]+)+");
    protected final Option option;
    protected final String name;
    protected final OptionCollection.ArgumentType argumentType;

    AbstractOption(Option option, String name) {
        this.option = option;
        this.name = name;
        this.argumentType = option.hasArg() ? (option.getArgName() == null ? OptionCollection.ArgumentType.ARG : OptionCollection.ArgumentType.valueOf(option.getArgName().toUpperCase(Locale.ROOT))) : OptionCollection.ArgumentType.NONE;
    }

    public Option getOption() {
        return this.option;
    }

    public String getDefaultValue() {
        Arg arg = Arg.findArg(this.option);
        return arg == null ? null : arg.defaultValue();
    }

    protected abstract String cleanupName(Option var1);

    public abstract String getExample();

    public String cleanupName() {
        return this.cleanupName(this.option);
    }

    public String cleanup(String str) {
        String workingStr = str;
        if (StringUtils.isNotBlank(workingStr)) {
            HashMap maps = new HashMap();
            Matcher matcher = PATTERN.matcher(workingStr);
            while (matcher.find()) {
                String key = matcher.group();
                String optKey = key.substring(2);
                Optional<Option> maybeResult = Arg.getOptions().getOptions().stream().filter(o -> optKey.equals(o.getOpt()) || optKey.equals(o.getLongOpt())).findFirst();
                maybeResult.ifPresent(value -> maps.put(key, this.cleanupName((Option)value)));
            }
            for (Map.Entry entry : maps.entrySet()) {
                workingStr = workingStr.replaceAll(Pattern.quote(String.format("%s", entry.getKey())), (String)entry.getValue());
            }
        }
        return workingStr;
    }

    public final String getName() {
        return this.name;
    }

    public abstract String getText();

    public final String getDescription() {
        return this.cleanup(this.option.getDescription());
    }

    public final Class<?> getType() {
        return this.option.hasArg() ? (Class)this.option.getType() : Boolean.TYPE;
    }

    public final String getArgName() {
        return this.argumentType.getDisplayName();
    }

    public final OptionCollection.ArgumentType getArgType() {
        return this.argumentType;
    }

    public final boolean isDeprecated() {
        return this.option.isDeprecated();
    }

    public final boolean isRequired() {
        return this.option.isRequired();
    }

    public final boolean hasArg() {
        return this.option.hasArg();
    }

    public final boolean hasArgs() {
        return this.option.hasArgs();
    }

    public final int argCount() {
        return this.option.getArgs();
    }

    public final String keyValue() {
        return String.format("\"%s\"", StringUtils.defaultIfEmpty(this.option.getLongOpt(), this.option.getOpt()));
    }

    public final String getDeprecated() {
        return this.option.isDeprecated() ? this.cleanup(StringUtils.defaultIfEmpty(this.option.getDeprecated().toString(), "")) : "";
    }
}

