/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.jaxws.service;

import org.apache.cxf.Bus;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

public class AnnotationFeature extends AbstractFeature {

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        provider.getInInterceptors().add(new AnnotationFeatureInterceptor());
        provider.getOutInterceptors().add(new AnnotationFeatureInterceptor());
    }

    public static class AnnotationFeatureInterceptor extends AbstractPhaseInterceptor<Message> {

        public AnnotationFeatureInterceptor() {
            super(Phase.SEND);
        }

        public void handleMessage(Message message) {
            System.out.println("Handle Message in AnnotationFeatureInterceptor");
        }

    }

}
