/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.reactor.MonoKt;
import kotlinx.coroutines.reactor.ReactorFlowKt;
import org.reactivestreams.Publisher;
import org.springframework.core.KotlinDetector;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class CoroutinesUtils {
    public static <T> Mono<T> deferredToMono(Deferred<T> source) {
        return MonoKt.mono((CoroutineContext)Dispatchers.getUnconfined(), (scope, continuation) -> source.await(continuation));
    }

    public static <T> Deferred<T> monoToDeferred(Mono<T> source) {
        return BuildersKt.async((CoroutineScope)GlobalScope.INSTANCE, (CoroutineContext)Dispatchers.getUnconfined(), (CoroutineStart)CoroutineStart.DEFAULT, (scope, continuation) -> MonoKt.awaitSingleOrNull((Mono)source, (Continuation)continuation));
    }

    public static Publisher<?> invokeSuspendingFunction(Method method, Object target, Object ... args) {
        return CoroutinesUtils.invokeSuspendingFunction((CoroutineContext)Dispatchers.getUnconfined(), method, target, args);
    }

    public static Publisher<?> invokeSuspendingFunction(CoroutineContext context, Method method, Object target, Object ... args) {
        Assert.isTrue(KotlinDetector.isSuspendingFunction(method), "'method' must be a suspending function");
        KFunction function = Objects.requireNonNull(ReflectJvmMapping.getKotlinFunction((Method)method));
        if (method.isAccessible() && !KCallablesJvm.isAccessible((KCallable)function)) {
            KCallablesJvm.setAccessible((KCallable)function, (boolean)true);
        }
        Mono mono = MonoKt.mono((CoroutineContext)context, (scope, continuation) -> KCallables.callSuspend((KCallable)function, (Object[])CoroutinesUtils.getSuspendedFunctionArgs(method, target, args), (Continuation)continuation)).filter(result -> !Objects.equals(result, Unit.INSTANCE)).onErrorMap(InvocationTargetException.class, InvocationTargetException::getTargetException);
        KClassifier returnType = function.getReturnType().getClassifier();
        if (returnType != null) {
            KClass kClass;
            if (returnType.equals(JvmClassMappingKt.getKotlinClass(Flow.class))) {
                return mono.flatMapMany(CoroutinesUtils::asFlux);
            }
            if (returnType.equals(JvmClassMappingKt.getKotlinClass(Mono.class))) {
                return mono.flatMap(o -> (Mono)o);
            }
            if (returnType instanceof KClass && Publisher.class.isAssignableFrom(JvmClassMappingKt.getJavaClass((KClass)(kClass = (KClass)returnType)))) {
                return mono.flatMapMany(o -> (Publisher)o);
            }
        }
        return mono;
    }

    private static Object[] getSuspendedFunctionArgs(Method method, Object target, Object ... args) {
        int length = args.length == method.getParameterCount() - 1 ? args.length + 1 : args.length;
        Object[] functionArgs = new Object[length];
        functionArgs[0] = target;
        System.arraycopy(args, 0, functionArgs, 1, length - 1);
        return functionArgs;
    }

    private static Flux<?> asFlux(Object flow) {
        return ReactorFlowKt.asFlux((Flow)((Flow)flow));
    }
}

