/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class EntityPartImpl
implements EntityPart {
    private final String name;
    private final String fileName;
    private final InputStream content;
    private final MultivaluedMap<String, String> headers;
    private final MediaType mediaType;
    private final ProviderFactory providers;

    EntityPartImpl(ProviderFactory providers, String name, String fileName, InputStream content, MultivaluedMap<String, String> headers, MediaType mediaType) {
        this.providers = providers;
        this.name = name;
        this.fileName = fileName;
        this.content = content;
        this.headers = headers;
        this.mediaType = mediaType;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public InputStream getContent() {
        return this.content;
    }

    public <T> T getContent(Class<T> type) throws IllegalArgumentException, IllegalStateException, IOException, WebApplicationException {
        Message message = JAXRSUtils.getCurrentMessage();
        MessageBodyReader<T> reader = this.providers.createMessageBodyReader(type, null, null, this.mediaType, message);
        return (T)reader.readFrom(type, null, null, this.mediaType, this.headers, this.content);
    }

    public <T> T getContent(GenericType<T> type) throws IllegalArgumentException, IllegalStateException, IOException, WebApplicationException {
        Message message = JAXRSUtils.getCurrentMessage();
        MessageBodyReader reader = this.providers.createMessageBodyReader(type.getRawType(), type.getType(), null, this.mediaType, message);
        return (T)reader.readFrom(type.getRawType(), type.getType(), null, this.mediaType, this.headers, this.content);
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }
}

