/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.brokerConnectivity;

import java.io.Serializable;
import java.util.Objects;

public abstract class BrokerConnectConfiguration
implements Serializable {
    private static final long serialVersionUID = 8026604526022462048L;
    private String name;
    private String uri;
    private String user;
    private String password;
    private int reconnectAttempts = -1;
    private int retryInterval = 5000;
    private boolean autostart = true;

    public BrokerConnectConfiguration(String name, String uri) {
        this.name = name;
        this.uri = uri;
    }

    public abstract void parseURI() throws Exception;

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public BrokerConnectConfiguration setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public BrokerConnectConfiguration setUser(String user) {
        this.user = user;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public BrokerConnectConfiguration setPassword(String password) {
        this.password = password;
        return this;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public BrokerConnectConfiguration setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public BrokerConnectConfiguration setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BrokerConnectConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isAutostart() {
        return this.autostart;
    }

    public BrokerConnectConfiguration setAutostart(boolean autostart) {
        this.autostart = autostart;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.autostart, this.name, this.password, this.reconnectAttempts, this.retryInterval, this.uri, this.user);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrokerConnectConfiguration other = (BrokerConnectConfiguration)obj;
        return Objects.equals(this.name, other.name) && this.autostart == other.autostart && Objects.equals(this.password, other.password) && this.reconnectAttempts == other.reconnectAttempts && this.retryInterval == other.retryInterval && Objects.equals(this.uri, other.uri) && Objects.equals(this.user, other.user);
    }
}

