/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.asyncclient;

import java.io.IOException;
import org.apache.cxf.transport.http.asyncclient.AsyncWrappedOutputStreamBase;
import org.apache.cxf.transport.http.asyncclient.CXFResponseCallback;
import org.apache.cxf.transport.http.asyncclient.SharedInputBuffer;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class CXFHttpAsyncResponseConsumer
implements HttpAsyncResponseConsumer<Boolean> {
    private final SharedInputBuffer buf;
    private final AsyncWrappedOutputStreamBase outstream;
    private final CXFResponseCallback responseCallback;
    private volatile boolean completed;
    private volatile Exception exception;
    private volatile HttpResponse response;

    public CXFHttpAsyncResponseConsumer(AsyncWrappedOutputStreamBase asyncWrappedOutputStream, SharedInputBuffer buf, CXFResponseCallback responseCallback) {
        this.outstream = asyncWrappedOutputStream;
        this.responseCallback = responseCallback;
        this.buf = buf;
    }

    public void close() throws IOException {
        this.buf.close();
    }

    public boolean cancel() {
        this.completed = true;
        this.buf.shutdown();
        return true;
    }

    public void responseReceived(HttpResponse resp) throws IOException, HttpException {
        this.response = resp;
        this.responseCallback.responseReceived(this.response);
    }

    public void consumeContent(ContentDecoder dec, IOControl ioc) throws IOException {
        if (this.outstream.retrySetHttpResponse(this.response)) {
            this.buf.consumeContent(dec, ioc);
        }
    }

    public void responseCompleted(HttpContext context) {
        this.completed = true;
        this.buf.close();
    }

    public void failed(Exception ex) {
        this.completed = true;
        this.exception = ex;
        this.buf.shutdown();
    }

    public Exception getException() {
        return this.exception;
    }

    public Boolean getResult() {
        return this.exception != null;
    }

    public boolean isDone() {
        return this.completed;
    }
}

