/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.codegen.c.generators;

import java.io.Serializable;
import org.apache.daffodil.codegen.c.generators.BinaryValueCodeGenerator;
import org.apache.daffodil.codegen.c.generators.CodeGeneratorState;
import org.apache.daffodil.codegen.c.generators.package$;
import org.apache.daffodil.core.dsom.ElementBase;
import org.apache.daffodil.lib.schema.annotation.props.gen.ByteOrder;
import org.apache.daffodil.lib.util.MaybeJULong;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dsom.CompiledExpression;
import org.apache.daffodil.runtime1.processors.ExplicitLengthEv;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface HexBinaryCodeGenerator
extends BinaryValueCodeGenerator {
    public static void hexBinaryLengthPrefixedGenerateCode$(HexBinaryCodeGenerator $this, ElementBase e, CodeGeneratorState cgState) {
        $this.hexBinaryLengthPrefixedGenerateCode(e, cgState);
    }

    default public void hexBinaryLengthPrefixedGenerateCode(ElementBase e, CodeGeneratorState cgState) {
        JProcedure1 & Serializable addField = (JProcedure1 & Serializable)_$1 -> this.hexBinaryPrefixedLengthAddField(e, (String)_$1, cgState);
        JProcedure1 & Serializable validateFixed = (JProcedure1 & Serializable)_$2 -> this.hexBinaryValidateFixed(e, (String)_$2, cgState);
        this.binaryValueGenerateCode(e, (Function1<String, BoxedUnit>)addField, (Function1<String, BoxedUnit>)validateFixed, cgState);
    }

    public static void hexBinarySpecifiedLengthGenerateCode$(HexBinaryCodeGenerator $this, ElementBase e, CodeGeneratorState cgState) {
        $this.hexBinarySpecifiedLengthGenerateCode(e, cgState);
    }

    default public void hexBinarySpecifiedLengthGenerateCode(ElementBase e, CodeGeneratorState cgState) {
        JProcedure1 & Serializable addField = (JProcedure1 & Serializable)_$3 -> this.hexBinarySpecifiedLengthAddField(e, (String)_$3, cgState);
        JProcedure1 & Serializable validateFixed = (JProcedure1 & Serializable)_$4 -> this.hexBinaryValidateFixed(e, (String)_$4, cgState);
        this.binaryValueGenerateCode(e, (Function1<String, BoxedUnit>)addField, (Function1<String, BoxedUnit>)validateFixed, cgState);
    }

    private void hexBinaryPrefixedLengthAddField(ElementBase e, String deref, CodeGeneratorState cgState) {
        String string;
        String indent1 = cgState.hasChoice() ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
        String indent2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(deref)) ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
        String localName = cgState.cName(e);
        String field = "instance->" + localName + deref;
        NodeInfo.PrimType primType = (NodeInfo.PrimType)e.prefixedLengthElementDecl().optPrimType().get();
        if (NodeInfo.PrimType$.Byte$.MODULE$.equals(primType) || NodeInfo.PrimType$.Short$.MODULE$.equals(primType) || NodeInfo.PrimType$.Int$.MODULE$.equals(primType) || NodeInfo.PrimType$.Long$.MODULE$.equals(primType) || NodeInfo.PrimType$.Integer$.MODULE$.equals(primType)) {
            string = "int";
        } else if (NodeInfo.PrimType$.UnsignedByte$.MODULE$.equals(primType) || NodeInfo.PrimType$.UnsignedShort$.MODULE$.equals(primType) || NodeInfo.PrimType$.UnsignedInt$.MODULE$.equals(primType) || NodeInfo.PrimType$.UnsignedLong$.MODULE$.equals(primType) || NodeInfo.PrimType$.NonNegativeInteger$.MODULE$.equals(primType)) {
            string = "uint";
        } else {
            NodeInfo.PrimType p = primType;
            throw e.SDE("Prefixed length PrimType %s is not supported in C code generator.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{p.toString()}));
        }
        String intType = string;
        long intLen = ((MaybeJULong)e.prefixedLengthElementDecl().elementLengthInBitsEv().constValue()).get();
        String primType2 = intType + intLen;
        Object object = e.prefixedLengthElementDecl().byteOrderEv().constValue();
        ByteOrder.BigEndian$ bigEndian$ = ByteOrder.BigEndian$.MODULE$;
        String conv = !(object != null ? !object.equals(bigEndian$) : bigEndian$ != null) ? "be" : "le";
        String function = conv + "_" + primType2;
        String lenVar = "_l_" + localName;
        String initERDStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    " + field + ".dynamic = true;"));
        String parseStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    " + primType2 + "_t " + lenVar + ";\n         |" + indent1 + indent2 + "    parse_" + function + "(&" + lenVar + ", " + intLen + ", pstate);\n         |" + indent1 + indent2 + "    if (pstate->pu.error) return;\n         |" + indent1 + indent2 + "    alloc_hexBinary(&" + field + ", " + lenVar + ", pstate);\n         |" + indent1 + indent2 + "    if (pstate->pu.error) return;\n         |" + indent1 + indent2 + "    parse_hexBinary(&" + field + ", pstate);\n         |" + indent1 + indent2 + "    if (pstate->pu.error) return;"));
        String unparseStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    unparse_" + function + "(" + field + ".lengthInBytes, " + intLen + ", ustate);\n         |" + indent1 + indent2 + "    if (ustate->pu.error) return;\n         |" + indent1 + indent2 + "    unparse_hexBinary(" + field + ", ustate);\n         |" + indent1 + indent2 + "    if (ustate->pu.error) return;"));
        cgState.addSimpleTypeStatements(initERDStatement, parseStatement, unparseStatement);
    }

    private void hexBinarySpecifiedLengthAddField(ElementBase e, String deref, CodeGeneratorState cgState) {
        String expression;
        String indent1 = cgState.hasChoice() ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
        String indent2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(deref)) ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
        String localName = cgState.cName(e);
        String field = "instance->" + localName + deref;
        String fieldArray = "instance->_a_" + localName + deref;
        long specifiedLength = e.elementLengthInBitsEv().isConstant() ? ((MaybeJULong)e.elementLengthInBitsEv().constValue()).get() : -1L;
        String primType = "size_t";
        String lenVar = "_l_" + localName;
        if (e.elementLengthInBitsEv().isConstant()) {
            v0 = BoxesRunTime.boxToLong((long)((MaybeJULong)e.elementLengthInBitsEv().constValue()).get()).toString();
        } else {
            String cExpr;
            CompiledExpression compiledExpression = ((ExplicitLengthEv)e.elementLengthInBitsEv().lengthEv()).expr();
            String expr = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(compiledExpression.toBriefXML(compiledExpression.toBriefXML$default$1())), "'{")), "}'").trim();
            v0 = expression = (cExpr = cgState.cExpression(expr));
        }
        String initERDStatement = specifiedLength > 0L ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    " + field + ".array = " + fieldArray + ";\n           |" + indent1 + indent2 + "    " + field + ".lengthInBytes = sizeof(" + fieldArray + ");\n           |" + indent1 + indent2 + "    " + field + ".dynamic = false;")) : (specifiedLength == 0L ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    " + field + ".array = NULL;\n           |" + indent1 + indent2 + "    " + field + ".lengthInBytes = 0;\n           |" + indent1 + indent2 + "    " + field + ".dynamic = false;")) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    " + field + ".dynamic = true;")));
        String parseStatement = specifiedLength >= 0L ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    parse_hexBinary(&" + field + ", pstate);\n           |" + indent1 + indent2 + "    if (pstate->pu.error) return;")) : StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    " + primType + " " + lenVar + " = " + expression + ";\n           |" + indent1 + indent2 + "    alloc_hexBinary(&" + field + ", " + lenVar + ", pstate);\n           |" + indent1 + indent2 + "    if (pstate->pu.error) return;\n           |" + indent1 + indent2 + "    parse_hexBinary(&" + field + ", pstate);\n           |" + indent1 + indent2 + "    if (pstate->pu.error) return;"));
        String unparseStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    unparse_hexBinary(" + field + ", ustate);\n         |" + indent1 + indent2 + "    if (ustate->pu.error) return;"));
        cgState.addSimpleTypeStatements(initERDStatement, parseStatement, unparseStatement);
    }

    private void hexBinaryValidateFixed(ElementBase e, String deref, CodeGeneratorState cgState) {
        String indent1 = cgState.hasChoice() ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
        String indent2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(deref)) ? package$.MODULE$.INDENT() : package$.MODULE$.NO_INDENT();
        String localName = cgState.cName(e);
        String field = "instance->" + localName + deref;
        String fixed = localName + "_fixed";
        String array = StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(e.fixedValueAsString()), 2).mkString("0x", ", 0x", "");
        String initERDStatement = "";
        String parseStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    uint8_t " + fixed + "[] = {" + array + "};\n         |" + indent1 + indent2 + "    validate_fixed_attribute(memcmp(" + field + ".array, " + fixed + ", sizeof(" + fixed + ")) == 0, \"" + localName + "\", &pstate->pu);\n         |" + indent1 + indent2 + "    if (pstate->pu.error) return;"));
        String unparseStatement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(indent1 + indent2 + "    uint8_t " + fixed + "[] = {" + array + "};\n         |" + indent1 + indent2 + "    validate_fixed_attribute(memcmp(" + field + ".array, " + fixed + ", sizeof(" + fixed + ")) == 0, \"" + localName + "\", &ustate->pu);\n         |" + indent1 + indent2 + "    if (ustate->pu.error) return;"));
        cgState.addSimpleTypeStatements(initERDStatement, parseStatement, unparseStatement);
    }
}

