/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SerializerDeserializerTest {
    @Test
    public void validSketchType() {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)SerializerDeserializer.SketchType.CompactTupleSketch.ordinal();
        Assert.assertEquals((Object)SerializerDeserializer.getSketchType((MemorySegment)MemorySegment.ofArray(bytes)), (Object)SerializerDeserializer.SketchType.CompactTupleSketch);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void invalidSketchType() {
        byte[] bytes = new byte[4];
        bytes[3] = 33;
        SerializerDeserializer.getSketchType((MemorySegment)MemorySegment.ofArray(bytes));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void validateFamilyNotTuple() {
        SerializerDeserializer.validateFamily((byte)1, (byte)0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void validateFamilyWrongPreambleLength() {
        SerializerDeserializer.validateFamily((byte)((byte)Family.TUPLE.getID()), (byte)0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSeedHash() {
        Util.computeSeedHash((long)50541L);
    }
}

