/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.stream.StreamSourceFormat;

public final class PropertiesSourceFormat
implements StreamSourceFormat {
    private static final String KEY = "properties";
    private static final String FILENAME_EXTENSION = "properties";
    public static final String ROOT_ELEMENT_NAME = "properties";
    public static final String ENTRY_ELEMENT_NAME = "entry";
    public static final String KEY_ATTRIBUTE_NAME = "key";

    @Override
    public String getKey() {
        return "properties";
    }

    @Override
    public String getFilenameExtension() {
        return "properties";
    }

    @Override
    public SourceElement parse(InputStream inputStream, ControllerState controllerState) throws SourceException {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        OrderedProperties properties = new OrderedProperties();
        try {
            properties.load(inputStream);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new SourceException("Error parsing Properties source file: " + e.getMessage(), e);
        }
        SourceElement result = new SourceElement("properties");
        for (String key : properties.orderedKeySet()) {
            String value = properties.getProperty(key);
            SourceElement entryElement = new SourceElement(ENTRY_ELEMENT_NAME);
            entryElement.setAttribute(KEY_ATTRIBUTE_NAME, (Object)key);
            entryElement.setAttribute((String)null, (Object)value);
            result.getChildren().add(entryElement);
        }
        return result;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object other) {
        return other != null && other.getClass().equals(PropertiesSourceFormat.class);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class OrderedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final Set<String> keySet = new LinkedHashSet<String>();

        private OrderedProperties() {
        }

        @Override
        public Object put(Object key, Object value) {
            this.keySet.add(key.toString());
            return super.put(key, value);
        }

        public Set<String> orderedKeySet() {
            return Collections.unmodifiableSet(this.keySet);
        }

        @Override
        public int hashCode() {
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            hashCodeBuilder.append(this.keySet);
            return hashCodeBuilder.toHashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj) || this.getClass() != obj.getClass()) {
                return false;
            }
            OrderedProperties other = (OrderedProperties)obj;
            return this.keySet.equals(other.keySet);
        }
    }
}

