// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

#pragma once
#include <brpc/controller.h>
#include <bthread/types.h>
#include <butil/errno.h>
#include <fmt/format.h>
#include <gen_cpp/PaloInternalService_types.h>
#include <gen_cpp/Types_types.h>
#include <gen_cpp/internal_service.pb.h>
#include <gen_cpp/types.pb.h>
#include <glog/logging.h>
#include <google/protobuf/stubs/callback.h>

#include <atomic>
#include <cstddef>
#include <cstdint>
// IWYU pragma: no_include <bits/chrono.h>
#include <chrono> // IWYU pragma: keep
#include <vector>

#include "common/status.h"
#include "runtime/exec_env.h"
#include "runtime/types.h"
#include "vec/data_types/data_type.h"
#include "vec/exprs/vexpr_fwd.h"
#include "vec/sink/async_writer_sink.h"
#include "vec/sink/writer/vtablet_writer_v2.h"

namespace doris {

namespace vectorized {

inline constexpr char VOLAP_TABLE_SINK_V2[] = "VOlapTableSinkV2";

class VOlapTableSinkV2 final : public AsyncWriterSink<VTabletWriterV2, VOLAP_TABLE_SINK_V2> {
public:
    // Construct from thrift struct which is generated by FE.
    VOlapTableSinkV2(ObjectPool* pool, const RowDescriptor& row_desc,
                     const std::vector<TExpr>& texprs);

    ~VOlapTableSinkV2() override;

    Status close(RuntimeState* state, Status exec_status) override;

private:
    Status _close_status = Status::OK();
};

} // namespace vectorized
} // namespace doris
